/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.mekanism;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.block.entity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import mekanism.api.heat.ISidedHeatHandler;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public record PNC2MekHeatAdapter(@NotNull IHeatExchangerLogic heatExchanger, Direction direction) implements ISidedHeatHandler
{
    public static ISidedHeatHandler maybe(BlockEntity blockEntity, Direction direction) {
        IHeatExchangingTE heat;
        IHeatExchangerLogic exchanger;
        if (blockEntity instanceof IHeatExchangingTE && (exchanger = (heat = (IHeatExchangingTE)blockEntity).getHeatExchanger()) != null) {
            return new PNC2MekHeatAdapter(exchanger, direction);
        }
        return null;
    }

    @Nullable
    public Direction getHeatSideFor() {
        return this.direction;
    }

    public int getHeatCapacitorCount(@Nullable Direction direction) {
        return 1;
    }

    public double getTemperature(int i, @Nullable Direction direction) {
        return this.heatExchanger.getTemperature();
    }

    public double getInverseConduction(int i, @Nullable Direction direction) {
        return this.heatExchanger.getThermalResistance() * (Double)ConfigHelper.common().integration.mekThermalResistanceFactor.get();
    }

    public double getHeatCapacity(int i, @Nullable Direction direction) {
        return this.heatExchanger.getThermalCapacity();
    }

    public void handleHeat(int i, double amount, @Nullable Direction direction) {
        this.heatExchanger.addHeat(amount * (Double)ConfigHelper.common().integration.mekThermalEfficiencyFactor.get());
    }
}

