/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.inventory;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.inventory.AbstractPneumaticCraftMenu;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetGlobalVariable;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModMenuTypes;
import me.desht.pneumaticcraft.common.remote.SavedRemoteLayout;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.variables.GlobalVariableHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class RemoteMenu
extends AbstractPneumaticCraftMenu<AbstractPneumaticCraftBlockEntity> {
    private final List<String> syncedVars;
    private final BlockPos[] lastValues;
    private final InteractionHand hand;
    private final List<String> allKnownGlobalVars;
    private final UUID playerId;

    public RemoteMenu(MenuType<? extends RemoteMenu> type, int windowId, Inventory playerInventory, InteractionHand hand) {
        super(type, windowId, playerInventory);
        this.hand = hand;
        this.allKnownGlobalVars = List.of();
        this.playerId = playerInventory.player.getUUID();
        this.syncedVars = List.copyOf(this.getRelevantVariableNames(playerInventory.player, playerInventory.player.getItemInHand(hand)));
        this.lastValues = new BlockPos[this.syncedVars.size()];
    }

    private RemoteMenu(MenuType<RemoteMenu> type, int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        super(type, windowId, playerInventory);
        this.hand = (InteractionHand)buffer.readEnum(InteractionHand.class);
        this.allKnownGlobalVars = buffer.readList(FriendlyByteBuf::readUtf);
        this.playerId = playerInventory.player.getUUID();
        this.syncedVars = List.copyOf(this.getRelevantVariableNames(playerInventory.player, playerInventory.player.getItemInHand(this.hand)));
        this.lastValues = new BlockPos[this.syncedVars.size()];
    }

    public static RemoteMenu createRemoteContainer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new RemoteMenu(ModMenuTypes.REMOTE.get(), windowId, playerInventory, buffer);
    }

    public static RemoteMenu createRemoteEditorContainer(int windowId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new RemoteMenu(ModMenuTypes.REMOTE_EDITOR.get(), windowId, playerInventory, buffer);
    }

    private Set<String> getRelevantVariableNames(Player player, @Nonnull ItemStack remote) {
        SavedRemoteLayout layout = SavedRemoteLayout.fromItem(remote);
        HashSet variables = new HashSet();
        layout.getWidgets().forEach(w -> w.discoverVariables(variables, this.playerId));
        HashSet<String> result = new HashSet<String>();
        variables.forEach(varName -> {
            if (!((String)varName).isEmpty()) {
                if (!GlobalVariableHelper.getInstance().hasPrefix((String)varName)) {
                    if (!player.level().isClientSide) {
                        player.displayClientMessage((Component)PneumaticCraftUtils.xlate("pneumaticcraft.command.globalVariable.prefixReminder", varName).withStyle(ChatFormatting.GOLD), false);
                    }
                    varName = "#" + (String)varName;
                }
                result.add((String)varName);
            }
        });
        return result;
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        for (int i = 0; i < this.lastValues.length; ++i) {
            BlockPos newValue;
            String varName = this.syncedVars.get(i);
            if (varName.isEmpty() || (newValue = GlobalVariableHelper.getInstance().getPos(this.playerId, varName)) == null || newValue.equals((Object)this.lastValues[i])) continue;
            this.lastValues[i] = newValue;
            ServerPlayer serverPlayer = PneumaticCraftUtils.getPlayerFromId(this.playerId);
            if (serverPlayer == null) continue;
            NetworkHandler.sendToPlayer(PacketSetGlobalVariable.forPos(varName, newValue), serverPlayer);
        }
    }

    @Override
    public boolean stillValid(Player player) {
        return player.getItemInHand(this.hand).getItem() == ModItems.REMOTE.get();
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public List<String> allKnownGlobalVars() {
        return this.allKnownGlobalVars;
    }
}

