/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.progwidgets;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.desht.pneumaticcraft.api.drone.IDrone;
import me.desht.pneumaticcraft.api.drone.IProgWidget;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIBlockCondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.ICondition;
import me.desht.pneumaticcraft.common.drone.progwidgets.IJump;
import me.desht.pneumaticcraft.common.drone.progwidgets.IVariableSetWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidget;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetJump;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetText;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.ProgWidgetCC;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.DyeColor;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public abstract class ProgWidgetCondition
extends ProgWidgetInventoryBase
implements ICondition,
IJump,
IVariableSetWidget {
    private DroneAIBlockCondition evaluator;
    protected ConditionFields cond;

    protected static <P extends ProgWidgetCondition> Products.P3<RecordCodecBuilder.Mu<P>, ProgWidget.PositionFields, ProgWidgetInventoryBase.InvBaseFields, ConditionFields> condParts(RecordCodecBuilder.Instance<P> pInstance) {
        return ProgWidgetCondition.invParts(pInstance).and((App)ConditionFields.CODEC.fieldOf("cond").forGetter(p -> p.cond));
    }

    protected ProgWidgetCondition(ProgWidget.PositionFields pos, ProgWidgetInventoryBase.InvBaseFields inv, ConditionFields cond) {
        super(pos, inv);
        this.cond = cond;
    }

    protected ProgWidgetCondition() {
        this(ProgWidget.PositionFields.DEFAULT, ProgWidgetInventoryBase.InvBaseFields.DEFAULT, ConditionFields.DEFAULT);
    }

    @Override
    public Goal getWidgetAI(IDrone drone, IProgWidget widget) {
        if (this.evaluator == null || !(widget instanceof ProgWidgetCC)) {
            this.evaluator = this.getEvaluator(drone, widget);
        }
        return this.evaluator;
    }

    protected abstract DroneAIBlockCondition getEvaluator(IDrone var1, IProgWidget var2);

    @Override
    public String getMeasureVar() {
        return Objects.requireNonNullElse(this.cond.measureVar, "");
    }

    @Override
    public void setMeasureVar(String measureVar) {
        this.cond = this.cond.withMeasureVar(measureVar);
    }

    @Override
    public void getTooltip(List<Component> curTooltip) {
        super.getTooltip(curTooltip);
        if (!this.getMeasureVar().isEmpty()) {
            curTooltip.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.condition.measure", new Object[0]).append(this.getMeasureVar()));
        }
    }

    @Override
    public void addErrors(List<Component> curInfo, List<IProgWidget> widgets) {
        super.addErrors(curInfo, widgets);
        IProgWidget textTrue = this.getConnectedParameters()[this.getParameters().size() - 1];
        IProgWidget textFalse = this.getConnectedParameters()[this.getParameters().size() * 2 - 1];
        if (this.getMeasureVar().isEmpty() && this.getConnectedParameters()[this.getParameters().size() - 1] == null && this.getConnectedParameters()[this.getParameters().size() * 2 - 1] == null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.condition.error.noFlowControl", new Object[0]));
        } else if (this.getOutputWidget() != null && textTrue != null && textFalse != null) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.progWidget.condition.error.badFlowControl", new Object[0]));
        }
    }

    @Override
    public IProgWidget getOutputWidget(IDrone drone, List<IProgWidget> allWidgets) {
        if (this.evaluator != null) {
            boolean evaluation = this.evaluate(drone, this);
            if (evaluation) {
                drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.condition.evaluatedTrue");
            } else {
                drone.getDebugger().addEntry("pneumaticcraft.gui.progWidget.condition.evaluatedFalse");
            }
            return ProgWidgetJump.jumpToLabel(drone, allWidgets, this, evaluation);
        }
        Log.error("Shouldn't be happening! ProgWidgetCondition evaluator is null for some reason", new Object[0]);
        return super.getOutputWidget(drone, allWidgets);
    }

    @Override
    public boolean evaluate(IDrone drone, IProgWidget widget) {
        return this.evaluator.getResult();
    }

    @Override
    public boolean isAndFunction() {
        return this.cond.isAndFunc;
    }

    @Override
    public void setAndFunction(boolean isAndFunction) {
        this.cond = this.cond.withIsAndFunc(isAndFunction);
    }

    @Override
    public IProgWidget.WidgetDifficulty getDifficulty() {
        return IProgWidget.WidgetDifficulty.MEDIUM;
    }

    @Override
    public List<String> getPossibleJumpLocations() {
        IProgWidget widget = this.getConnectedParameters()[this.getParameters().size() - 1];
        ProgWidgetText textWidget = widget != null ? (ProgWidgetText)widget : null;
        IProgWidget widget2 = this.getConnectedParameters()[this.getParameters().size() * 2 - 1];
        ProgWidgetText textWidget2 = widget2 != null ? (ProgWidgetText)widget2 : null;
        ArrayList<String> locations = new ArrayList<String>();
        if (textWidget != null) {
            locations.add(textWidget.string);
        }
        if (textWidget2 != null) {
            locations.add(textWidget2.string);
        }
        return locations;
    }

    @Override
    public int getRequiredCount() {
        return this.getCount();
    }

    @Override
    public void setRequiredCount(int count) {
        this.setCount(count);
    }

    @Override
    public ICondition.Operator getOperator() {
        return this.cond.op;
    }

    @Override
    public void setOperator(ICondition.Operator operator) {
        this.cond = this.cond.withOp(operator);
    }

    @Override
    protected boolean isUsingSides() {
        return false;
    }

    @Override
    public List<Component> getExtraStringInfo() {
        MutableComponent anyAll = PneumaticCraftUtils.xlate(this.isAndFunction() ? "pneumaticcraft.gui.misc.all" : "pneumaticcraft.gui.misc.any", new Object[0]).append(" " + this.getOperator().toString() + " " + this.getRequiredCount());
        return this.getMeasureVar().isEmpty() ? Collections.singletonList(anyAll) : ImmutableList.of((Object)anyAll, (Object)this.varAsTextComponent(this.getMeasureVar()));
    }

    @Override
    public DyeColor getColor() {
        return DyeColor.CYAN;
    }

    @Override
    public void addVariables(Set<String> variables) {
        super.addVariables(variables);
        if (!this.getMeasureVar().isEmpty()) {
            variables.add(this.getMeasureVar());
        }
    }

    @Override
    public String getVariable() {
        return this.getMeasureVar();
    }

    @Override
    public void setVariable(String variable) {
        this.setMeasureVar(variable);
    }

    public ConditionFields conditionFields() {
        return this.cond;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean baseEquals(ProgWidget other) {
        if (!super.baseEquals(other)) return false;
        if (!(other instanceof ProgWidgetCondition)) return false;
        ProgWidgetCondition c = (ProgWidgetCondition)other;
        if (!this.cond.equals(c.cond)) return false;
        return true;
    }

    @Override
    protected int baseHashCode() {
        return Objects.hash(this.positionFields, this.invBaseFields, this.cond);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgWidgetCondition that = (ProgWidgetCondition)o;
        return this.baseEquals(that);
    }

    @Override
    public int hashCode() {
        return this.baseHashCode();
    }

    public record ConditionFields(boolean isAndFunc, ICondition.Operator op, String measureVar) {
        public static final ConditionFields DEFAULT = new ConditionFields(false, ICondition.Operator.GE, "");
        public static final Codec<ConditionFields> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.BOOL.optionalFieldOf("and_func", (Object)false).forGetter(ConditionFields::isAndFunc), (App)StringRepresentable.fromEnum(ICondition.Operator::values).optionalFieldOf("cond_op", (Object)ICondition.Operator.GE).forGetter(ConditionFields::op), (App)Codec.STRING.optionalFieldOf("measure_var", (Object)"").forGetter(ConditionFields::measureVar)).apply((Applicative)builder, ConditionFields::new));
        public static final StreamCodec<FriendlyByteBuf, ConditionFields> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ConditionFields::isAndFunc, (StreamCodec)NeoForgeStreamCodecs.enumCodec(ICondition.Operator.class), ConditionFields::op, (StreamCodec)ByteBufCodecs.STRING_UTF8, ConditionFields::measureVar, ConditionFields::new);

        public ConditionFields withIsAndFunc(boolean isAndFunc) {
            return new ConditionFields(isAndFunc, this.op, this.measureVar);
        }

        public ConditionFields withOp(ICondition.Operator op) {
            return new ConditionFields(this.isAndFunc, op, this.measureVar);
        }

        public ConditionFields withMeasureVar(String measureVar) {
            return new ConditionFields(this.isAndFunc, this.op, measureVar);
        }
    }
}

