/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.config.subconfig;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.common.config.subconfig.AuxConfigJson;
import me.desht.pneumaticcraft.common.config.subconfig.IAuxConfig;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;

public class ArmorFeatureStatus
extends AuxConfigJson {
    private final Map<ResourceLocation, Boolean> activeUpgrades = Maps.newHashMap();
    private boolean changed = true;
    public static final ArmorFeatureStatus INSTANCE = new ArmorFeatureStatus();

    private ArmorFeatureStatus() {
        super(false);
    }

    @Override
    public String getConfigFilename() {
        return "ArmorFeatureStatus";
    }

    @Override
    protected void writeToJson(JsonObject json) {
        json.addProperty("description", "Tracks the active upgrades for the Pneumatic Armor (clientside)");
        JsonObject features = new JsonObject();
        this.activeUpgrades.forEach((id, val) -> features.addProperty(id.toString(), val));
        json.add("features", (JsonElement)features);
    }

    @Override
    protected void readFromJson(JsonObject json) {
        if (json.has("features")) {
            JsonObject features = json.getAsJsonObject("features");
            for (Map.Entry entry : features.entrySet()) {
                try {
                    this.activeUpgrades.put(ResourceLocation.parse((String)((String)entry.getKey())), ((JsonElement)entry.getValue()).getAsBoolean());
                }
                catch (ClassCastException | IllegalStateException | ResourceLocationException e) {
                    Log.error("ignoring invalid entry '{}' in ArmorFeatureStatus.json: {}", entry.getKey(), e.getMessage());
                }
            }
        }
    }

    public void setUpgradeEnabled(ResourceLocation upgradeID, boolean enabled) {
        this.activeUpgrades.put(upgradeID, enabled);
        this.changed = true;
    }

    public boolean isUpgradeEnabled(ResourceLocation upgradeID) {
        if (!this.activeUpgrades.containsKey(upgradeID)) {
            String[] parts = upgradeID.getPath().split("\\.");
            IArmorUpgradeClientHandler<?> handler = ClientArmorRegistry.getInstance().getClientHandler(ResourceLocation.fromNamespaceAndPath((String)upgradeID.getNamespace(), (String)parts[0]));
            if (handler == null) {
                Log.warning("attempt to retrieve enablement for unknown upgrade ID '{}'", upgradeID);
                return false;
            }
            if (parts.length == 1) {
                this.setUpgradeEnabled(upgradeID, handler.isEnabledByDefault());
            } else {
                this.setUpgradeEnabled(upgradeID, handler.isEnabledByDefault(upgradeID.getPath()));
            }
        }
        return this.activeUpgrades.get(upgradeID);
    }

    @Override
    public IAuxConfig.Sidedness getSidedness() {
        return IAuxConfig.Sidedness.CLIENT;
    }

    public void saveIfChanged() {
        if (this.changed) {
            this.tryWriteToFile();
            this.changed = false;
        }
    }
}

