/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.List;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.utility.ChargingStationBlockEntity;
import me.desht.pneumaticcraft.common.registry.ModBlockEntityTypes;
import me.desht.pneumaticcraft.common.registry.ModDataComponents;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChargingStationBlock
extends AbstractCamouflageBlock
implements PneumaticCraftEntityBlock {
    public static final BooleanProperty CHARGE_PAD = BooleanProperty.create((String)"charge_pad");
    private static final VoxelShape CHARGING_STATION_N = VoxelShapeUtils.or(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)3.0, (double)15.0), Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)1.0), Block.box((double)5.0, (double)3.0, (double)1.0, (double)11.0, (double)11.0, (double)3.0), Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)4.0, (double)13.0), Block.box((double)11.0, (double)7.25, (double)1.25, (double)12.5, (double)7.75, (double)1.75), Block.box((double)12.0, (double)3.25, (double)1.25, (double)12.5, (double)7.25, (double)1.75), Block.box((double)11.25, (double)3.25, (double)2.0, (double)11.75, (double)8.25, (double)2.5), Block.box((double)11.25, (double)3.25, (double)2.5, (double)11.75, (double)3.75, (double)3.0), Block.box((double)12.0, (double)3.25, (double)1.75, (double)12.5, (double)3.75, (double)3.25), Block.box((double)3.5, (double)7.25, (double)1.25, (double)5.0, (double)7.75, (double)1.75), Block.box((double)3.5, (double)3.25, (double)1.75, (double)4.0, (double)3.75, (double)3.25), Block.box((double)10.75, (double)8.25, (double)2.0, (double)11.75, (double)8.75, (double)2.5), Block.box((double)3.5, (double)3.25, (double)1.25, (double)4.0, (double)7.25, (double)1.75), Block.box((double)4.25, (double)8.25, (double)2.0, (double)5.25, (double)8.75, (double)2.5), Block.box((double)4.25, (double)3.25, (double)2.0, (double)4.75, (double)8.25, (double)2.5), Block.box((double)4.25, (double)3.25, (double)2.5, (double)4.75, (double)3.75, (double)3.0), Block.box((double)5.0, (double)1.0, (double)0.0, (double)11.0, (double)5.0, (double)1.0));
    private static final VoxelShape CHARGING_STATION_E = VoxelShapeUtils.rotateY(CHARGING_STATION_N, 90);
    private static final VoxelShape CHARGING_STATION_S = VoxelShapeUtils.rotateY(CHARGING_STATION_E, 90);
    private static final VoxelShape CHARGING_STATION_W = VoxelShapeUtils.rotateY(CHARGING_STATION_S, 90);
    private static final VoxelShape CHARGING_PAD_N = VoxelShapeUtils.or(Block.box((double)4.0, (double)15.05, (double)4.0, (double)12.0, (double)16.05, (double)12.0), Block.box((double)2.0, (double)2.0, (double)13.0, (double)3.0, (double)15.0, (double)14.0), Block.box((double)13.0, (double)2.0, (double)13.0, (double)14.0, (double)15.0, (double)14.0), Block.box((double)13.0, (double)2.0, (double)2.0, (double)14.0, (double)15.0, (double)3.0), Block.box((double)2.0, (double)2.0, (double)2.0, (double)3.0, (double)15.0, (double)3.0), Block.box((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.box((double)2.0, (double)13.0, (double)3.0, (double)3.0, (double)14.0, (double)13.0), Block.box((double)13.0, (double)13.0, (double)3.0, (double)14.0, (double)14.0, (double)13.0), Block.box((double)3.0, (double)13.0, (double)13.0, (double)13.0, (double)14.0, (double)14.0), Block.box((double)3.0, (double)13.0, (double)2.0, (double)13.0, (double)14.0, (double)3.0), Block.box((double)5.0, (double)12.75, (double)0.25, (double)11.0, (double)16.05, (double)4.0), Block.box((double)5.7, (double)11.2, (double)1.7, (double)6.3, (double)12.8, (double)2.3), Block.box((double)6.95, (double)11.2, (double)1.7, (double)7.55, (double)12.8, (double)2.3), Block.box((double)11.45, (double)9.2, (double)1.2, (double)12.05, (double)13.8, (double)1.8), Block.box((double)10.95, (double)9.2, (double)1.2, (double)11.55, (double)9.8, (double)1.8), Block.box((double)10.95, (double)13.2, (double)1.2, (double)11.55, (double)13.8, (double)1.8));
    private static final VoxelShape CHARGING_PAD_E = VoxelShapeUtils.rotateY(CHARGING_PAD_N, 90);
    private static final VoxelShape CHARGING_PAD_S = VoxelShapeUtils.rotateY(CHARGING_PAD_E, 90);
    private static final VoxelShape CHARGING_PAD_W = VoxelShapeUtils.rotateY(CHARGING_PAD_S, 90);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_N = Shapes.join((VoxelShape)CHARGING_STATION_N, (VoxelShape)CHARGING_PAD_N, (BooleanOp)BooleanOp.OR);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_E = Shapes.join((VoxelShape)CHARGING_STATION_E, (VoxelShape)CHARGING_PAD_E, (BooleanOp)BooleanOp.OR);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_S = Shapes.join((VoxelShape)CHARGING_STATION_S, (VoxelShape)CHARGING_PAD_S, (BooleanOp)BooleanOp.OR);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_W = Shapes.join((VoxelShape)CHARGING_STATION_W, (VoxelShape)CHARGING_PAD_W, (BooleanOp)BooleanOp.OR);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_N_COLL = Shapes.join((VoxelShape)CHARGING_STATION_WITH_PAD_N, (VoxelShape)Shapes.block(), (BooleanOp)BooleanOp.AND);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_E_COLL = Shapes.join((VoxelShape)CHARGING_STATION_WITH_PAD_E, (VoxelShape)Shapes.block(), (BooleanOp)BooleanOp.AND);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_S_COLL = Shapes.join((VoxelShape)CHARGING_STATION_WITH_PAD_S, (VoxelShape)Shapes.block(), (BooleanOp)BooleanOp.AND);
    private static final VoxelShape CHARGING_STATION_WITH_PAD_W_COLL = Shapes.join((VoxelShape)CHARGING_STATION_WITH_PAD_W, (VoxelShape)Shapes.block(), (BooleanOp)BooleanOp.AND);
    private static final VoxelShape[] CHARGING_STATION = new VoxelShape[]{CHARGING_STATION_S, CHARGING_STATION_W, CHARGING_STATION_N, CHARGING_STATION_E};
    private static final VoxelShape[] CHARGING_STATION_WITH_PAD = new VoxelShape[]{CHARGING_STATION_WITH_PAD_S, CHARGING_STATION_WITH_PAD_W, CHARGING_STATION_WITH_PAD_N, CHARGING_STATION_WITH_PAD_E};
    private static final VoxelShape[] CHARGING_STATION_WITH_PAD_COLL = new VoxelShape[]{CHARGING_STATION_WITH_PAD_S_COLL, CHARGING_STATION_WITH_PAD_W_COLL, CHARGING_STATION_WITH_PAD_N_COLL, CHARGING_STATION_WITH_PAD_E_COLL};

    public ChargingStationBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CHARGE_PAD, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CHARGE_PAD});
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        Direction d = (Direction)state.getValue((Property)this.directionProperty());
        return (Boolean)state.getValue((Property)CHARGE_PAD) != false ? CHARGING_STATION_WITH_PAD[d.get2DDataValue()] : CHARGING_STATION[d.get2DDataValue()];
    }

    @Override
    public VoxelShape getCollisionShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        Direction d = (Direction)state.getValue((Property)this.directionProperty());
        return (Boolean)state.getValue((Property)CHARGE_PAD) != false ? CHARGING_STATION_WITH_PAD_COLL[d.get2DDataValue()] : CHARGING_STATION[d.get2DDataValue()];
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockAccess.getBlockEntity(pos, ModBlockEntityTypes.CHARGING_STATION.get()).map(teCS -> teCS.getRedstoneController().shouldEmit() ? 15 : 0).orElse(0);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ChargingStationBlockEntity(pPos, pState);
    }

    @Override
    public void addSerializableComponents(List<DataComponentType<?>> list) {
        super.addSerializableComponents(list);
        list.add(ModDataComponents.UPGRADE_ONLY.get());
    }

    public static class ItemBlockChargingStation
    extends BlockItem {
        public ItemBlockChargingStation(Block blockIn) {
            super(blockIn, ModItems.defaultProps());
        }

        public String getDescriptionId(ItemStack stack) {
            return (Boolean)stack.getOrDefault(ModDataComponents.UPGRADE_ONLY, (Object)false) != false ? super.getDescriptionId(stack) + ".upgrade_only" : super.getDescriptionId(stack);
        }
    }
}

