/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.ModLoadingUtil;
import de.cristelknight.cristellib.util.ModVersionComparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.util.GsonHelper;

public class Conditions {
    public static final MapCodec<Optional<List<JsonElement>>> CODEC = Codec.list((Codec)Codec.PASSTHROUGH.xmap(dynamic -> (JsonElement)dynamic.convert((DynamicOps)JsonOps.INSTANCE).getValue(), jsonObject -> new Dynamic((DynamicOps)JsonOps.INSTANCE, jsonObject))).optionalFieldOf("conditions");

    public static boolean readConditions(Optional<List<JsonElement>> conditions) {
        return conditions.isEmpty() || Conditions.readConditions(conditions.get());
    }

    public static boolean readConditions(List<JsonElement> jsonElements) {
        boolean bl = true;
        for (JsonElement e : jsonElements) {
            JsonObject o;
            if (!(e instanceof JsonObject) || Conditions.readCondition(o = (JsonObject)e)) continue;
            bl = false;
        }
        return bl;
    }

    public static boolean readCondition(JsonObject object) {
        String type = GsonHelper.getAsString((JsonObject)object, (String)"type");
        if (type.equals("mod_loaded")) {
            return ModLoadingUtil.isModLoaded(GsonHelper.getAsString((JsonObject)object, (String)"mod"));
        }
        if (type.equals("mod_loaded_with_version")) {
            String version = GsonHelper.getAsString((JsonObject)object, (String)"version");
            String mod = GsonHelper.getAsString((JsonObject)object, (String)"mod");
            for (ModVersionComparator comparator : ModVersionComparator.values()) {
                String sign = comparator.getSerialized();
                if (!version.startsWith(sign)) continue;
                return comparator.test(mod, version.replaceFirst(sign, ""));
            }
            CristelLib.LOGGER.warn("Couldn't compare \"version\": \"{}\" of \"mod\": \"{}\"", (Object)version, (Object)mod);
        }
        return false;
    }
}

