/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.compat.viewer.usage;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIFluids;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.api.datamaps.FluidFuel;
import aztech.modern_industrialization.api.datamaps.MIDataMaps;
import aztech.modern_industrialization.compat.viewer.abstraction.ViewerCategory;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import java.util.function.Consumer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.material.Fluid;

public class FluidFuelsCategory
extends ViewerCategory<Fluid> {
    public FluidFuelsCategory() {
        super(Fluid.class, MI.id("fluid_fuels"), (Component)MIText.FluidFuels.text(), MIFluids.DIESEL.getBucket().getDefaultInstance(), 150, 35);
    }

    @Override
    public void buildWorkstations(ViewerCategory.WorkstationConsumer consumer) {
        consumer.accept("lv_diesel_generator", "mv_diesel_generator", "hv_diesel_generator", "large_diesel_generator", "large_steam_boiler", "advanced_large_steam_boiler", "high_pressure_large_steam_boiler", "high_pressure_advanced_large_steam_boiler");
        consumer.accept(MIItem.DIESEL_JETPACK, MIItem.DIESEL_CHAINSAW, MIItem.DIESEL_MINING_DRILL);
    }

    @Override
    public void buildRecipes(RecipeManager recipeManager, RegistryAccess registryAccess, Consumer<Fluid> consumer) {
        for (Fluid fluid : registryAccess.registryOrThrow(Registries.FLUID)) {
            if (fluid.builtInRegistryHolder().getData(MIDataMaps.FLUID_FUELS) == null) continue;
            consumer.accept(fluid);
        }
    }

    @Override
    public void buildLayout(Fluid recipe, ViewerCategory.LayoutBuilder builder) {
        builder.inputSlot(15, 10).variant(FluidVariant.of(recipe));
    }

    @Override
    public void buildWidgets(Fluid recipe, ViewerCategory.WidgetList widgets) {
        int totalEnergy = FluidFuel.getEu(recipe);
        MutableComponent text = MIText.EuInDieselGenerator.text(totalEnergy);
        widgets.secondaryText((Component)text, 40.0f, 14.0f);
    }

    @Override
    public ResourceLocation getRecipeId(Fluid recipe) {
        return MI.id("/fluid_fuels/" + BuiltInRegistries.FLUID.getKey((Object)recipe).toString().replace(':', '_'));
    }
}

