/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.client;

import aztech.modern_industrialization.thirdparty.fabricrendering.QuadBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.Nullable;

public class QuadCube {
    private final ResourceLocation spriteLocation;
    @Nullable
    private BakedQuad[] quads;

    public QuadCube(ResourceLocation spriteLocation) {
        this.spriteLocation = spriteLocation;
    }

    public BakedQuad[] getQuads() {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(this.spriteLocation);
        if (this.quads == null || this.quads[0].getSprite() != sprite) {
            this.quads = QuadCube.buildQuads(sprite);
        }
        return this.quads;
    }

    private static BakedQuad[] buildQuads(TextureAtlasSprite sprite) {
        BakedQuad[] quads = new BakedQuad[6];
        for (Direction direction : Direction.values()) {
            QuadBuffer emitter = new QuadBuffer();
            emitter.square(direction, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            emitter.spriteBake(sprite, 4);
            quads[direction.get3DDataValue()] = emitter.toBakedQuad(sprite);
        }
        return quads;
    }
}

