/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization;

import aztech.modern_industrialization.MI;
import aztech.modern_industrialization.MIBlock;
import aztech.modern_industrialization.MIItem;
import aztech.modern_industrialization.MIKeybinds;
import aztech.modern_industrialization.MIRegistries;
import aztech.modern_industrialization.MIText;
import aztech.modern_industrialization.MITooltips;
import aztech.modern_industrialization.blocks.forgehammer.ForgeHammerScreen;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelRenderer;
import aztech.modern_industrialization.blocks.storage.barrel.BarrelTooltipData;
import aztech.modern_industrialization.blocks.storage.barrel.DeferredBarrelTextRenderer;
import aztech.modern_industrialization.blocks.storage.barrel.client.BarrelTooltipComponent;
import aztech.modern_industrialization.blocks.storage.tank.TankRenderer;
import aztech.modern_industrialization.client.MIRenderTypes;
import aztech.modern_industrialization.config.MIClientConfig;
import aztech.modern_industrialization.config.MIStartupConfig;
import aztech.modern_industrialization.datagen.MIDatagenClient;
import aztech.modern_industrialization.datagen.MIDatagenServer;
import aztech.modern_industrialization.datagen.model.DelegatingModelBuilder;
import aztech.modern_industrialization.items.ConfigCardItem;
import aztech.modern_industrialization.items.RedstoneControlModuleItem;
import aztech.modern_industrialization.items.SteamDrillHighlight;
import aztech.modern_industrialization.items.SteamDrillItem;
import aztech.modern_industrialization.items.SteamDrillTooltipComponent;
import aztech.modern_industrialization.items.armor.ClientKeyHandler;
import aztech.modern_industrialization.items.armor.HudRenderer;
import aztech.modern_industrialization.items.armor.JetpackParticleAdder;
import aztech.modern_industrialization.items.client.ClientConfigCardTooltip;
import aztech.modern_industrialization.machines.MachineBlock;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.MachineBlockEntityRenderer;
import aztech.modern_industrialization.machines.MachineOverlayClient;
import aztech.modern_industrialization.machines.blockentities.multiblocks.LargeTankMultiblockBlockEntity;
import aztech.modern_industrialization.machines.gui.MachineScreen;
import aztech.modern_industrialization.machines.models.MachineBakedModel;
import aztech.modern_industrialization.machines.models.MachineCasing;
import aztech.modern_industrialization.machines.models.MachineCasings;
import aztech.modern_industrialization.machines.models.MachineUnbakedModel;
import aztech.modern_industrialization.machines.models.UseBlockModelUnbakedModel;
import aztech.modern_industrialization.machines.multiblocks.MultiblockErrorHighlight;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBER;
import aztech.modern_industrialization.machines.multiblocks.MultiblockMachineBlockEntity;
import aztech.modern_industrialization.machines.multiblocks.MultiblockTankBER;
import aztech.modern_industrialization.misc.runtime_datagen.RuntimeDataGen;
import aztech.modern_industrialization.misc.version.VersionEvents;
import aztech.modern_industrialization.pipes.MIPipes;
import aztech.modern_industrialization.pipes.MIPipesClient;
import aztech.modern_industrialization.pipes.fluid.FluidPipeScreen;
import aztech.modern_industrialization.pipes.impl.DelegatingUnbakedModel;
import aztech.modern_industrialization.pipes.impl.PipeUnbakedModel;
import aztech.modern_industrialization.pipes.item.ItemPipeScreen;
import aztech.modern_industrialization.util.TextHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLConstructModEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterRenderBuffersEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(value={Dist.CLIENT}, modid="modern_industrialization")
public class MIClient {
    private static final List<Runnable> blockEntityRendererRegistrations = new ArrayList<Runnable>();

    @SubscribeEvent
    private static void init(FMLConstructModEvent ignored) {
        IEventBus modBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        Objects.requireNonNull(modBus);
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MIClientConfig.SPEC);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        NeoForge.EVENT_BUS.addListener(SteamDrillHighlight::onBlockHighlight);
        NeoForge.EVENT_BUS.addListener(MachineOverlayClient::onBlockOutline);
        DeferredBarrelTextRenderer.init();
        MultiblockErrorHighlight.init();
        MIPipesClient.setupClient(modBus);
        VersionEvents.init(ModLoadingContext.get().getActiveContainer());
        NeoForge.EVENT_BUS.addListener(RenderFrameEvent.Pre.class, event -> JetpackParticleAdder.addJetpackParticles(Minecraft.getInstance()));
        NeoForge.EVENT_BUS.addListener(ClientTickEvent.Post.class, event -> ClientKeyHandler.onEndTick(Minecraft.getInstance()));
        NeoForge.EVENT_BUS.addListener(ItemTooltipEvent.class, event -> {
            MITooltips.attachTooltip(event.getItemStack(), event.getToolTip());
            if (Minecraft.getInstance().level != null && MIClientConfig.INSTANCE.fuelTooltips.getAsBoolean()) {
                try {
                    int fuelTime = event.getItemStack().getBurnTime(null);
                    if (fuelTime > 0) {
                        long totalEu = (long)fuelTime * 20L;
                        event.getToolTip().add(new MITooltips.Line(MIText.BaseEuTotalStored).arg(totalEu, MITooltips.EU_PARSER).build());
                    }
                }
                catch (Exception e) {
                    MI.LOGGER.warn("Could not show MI fuel tooltip.", (Throwable)e);
                }
            }
            if (event.getFlags().isAdvanced() && MIClientConfig.INSTANCE.itemTagTooltips.getAsBoolean()) {
                List<ResourceLocation> ids = event.getItemStack().getTags().map(TagKey::location).sorted().toList();
                for (ResourceLocation id : ids) {
                    event.getToolTip().add(Component.literal((String)("#" + String.valueOf(id))).setStyle(TextHelper.GRAY_TEXT));
                }
            }
        });
        modBus.addListener(GatherDataEvent.class, event -> MIDatagenClient.configure(event.getGenerator(), event.getExistingFileHelper(), event.getLookupProvider(), event.includeServer(), false));
        modBus.addListener(RegisterRenderBuffersEvent.class, event -> event.registerRenderBuffer(MIRenderTypes.cutoutHighlight()));
        if (!(ModList.get().isLoaded("emi") || ModList.get().isLoaded("jei") || ModList.get().isLoaded("roughlyenoughitems"))) {
            NeoForge.EVENT_BUS.addListener(ClientPlayerNetworkEvent.LoggingIn.class, event -> {
                if (MIClientConfig.INSTANCE.missingRecipeViewerMessage.getAsBoolean()) {
                    event.getPlayer().displayClientMessage((Component)MIText.NoEmi.text().withStyle(ChatFormatting.GOLD), false);
                }
            });
        }
        if (MIStartupConfig.INSTANCE.datagenOnStartup.getAsBoolean()) {
            modBus.addListener(AddPackFindersEvent.class, event -> {
                if (event.getPackType() == PackType.CLIENT_RESOURCES) {
                    RuntimeDataGen.run(MIDatagenClient::configure, MIDatagenServer::configure);
                }
            });
        }
        MI.LOGGER.info("Modern Industrialization client setup done!");
    }

    @SubscribeEvent
    private static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register(MIRegistries.FORGE_HAMMER_MENU.get(), ForgeHammerScreen::new);
        event.register(MIRegistries.MACHINE_MENU.get(), MachineScreen::new);
        event.register(MIPipes.SCREEN_HANDLER_TYPE_ITEM_PIPE.get(), ItemPipeScreen::new);
        event.register(MIPipes.SCREEN_HANDLER_TYPE_FLUID_PIPE.get(), FluidPipeScreen::new);
    }

    @SubscribeEvent
    private static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register(DelegatingModelBuilder.LOADER_ID, DelegatingUnbakedModel.LOADER);
        event.register(MachineUnbakedModel.LOADER_ID, MachineUnbakedModel.LOADER);
        event.register(PipeUnbakedModel.LOADER_ID, PipeUnbakedModel.LOADER);
        event.register(UseBlockModelUnbakedModel.LOADER_ID, UseBlockModelUnbakedModel.LOADER);
    }

    @SubscribeEvent
    private static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        for (MachineCasing casing : MachineCasings.registeredCasings.values()) {
            event.register(MachineBakedModel.getCasingModelId(casing));
        }
    }

    public static <T extends BlockEntity, U extends T> void registerBlockEntityRenderer(Supplier<? extends BlockEntityType<? extends U>> bet, BlockEntityRendererProvider<T> renderer) {
        blockEntityRendererRegistrations.add(() -> BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)bet.get()), (BlockEntityRendererProvider)renderer));
    }

    @SubscribeEvent
    private static void registerBlockEntityRenderers(FMLClientSetupEvent event) {
        for (DeferredHolder blockDef : MIBlock.BLOCKS.getEntries()) {
            Object object = blockDef.get();
            if (!(object instanceof MachineBlock)) continue;
            MachineBlock machine = (MachineBlock)object;
            MachineBlockEntity blockEntity = machine.getBlockEntityInstance();
            BlockEntityType type = blockEntity.getType();
            if (blockEntity instanceof LargeTankMultiblockBlockEntity) {
                BlockEntityRenderers.register((BlockEntityType)type, MultiblockTankBER::new);
                continue;
            }
            if (blockEntity instanceof MultiblockMachineBlockEntity) {
                BlockEntityRenderers.register((BlockEntityType)type, MultiblockMachineBER::new);
                continue;
            }
            BlockEntityRenderers.register((BlockEntityType)type, c -> new MachineBlockEntityRenderer(c));
        }
        BlockEntityRenderers.register(MIRegistries.CREATIVE_BARREL_BE.get(), context -> new BarrelRenderer(0));
        BlockEntityRenderers.register(MIRegistries.CREATIVE_TANK_BE.get(), context -> new TankRenderer(0));
        blockEntityRendererRegistrations.forEach(Runnable::run);
    }

    @SubscribeEvent
    private static void registerClientTooltipComponents(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(BarrelTooltipData.class, BarrelTooltipComponent::new);
        event.register(ConfigCardItem.TooltipData.class, ClientConfigCardTooltip::new);
        event.register(SteamDrillItem.SteamDrillTooltipData.class, SteamDrillTooltipComponent::new);
    }

    @SubscribeEvent
    private static void registerGuiOverlays(RegisterGuiLayersEvent event) {
        event.registerAbove(VanillaGuiLayers.SELECTED_ITEM_NAME, MI.id("activation_status"), HudRenderer::onRenderHud);
    }

    @SubscribeEvent
    private static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        MIKeybinds.init(event);
    }

    @SubscribeEvent
    private static void registerItemProperties(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)MIItem.REDSTONE_CONTROL_MODULE.asItem(), (ResourceLocation)MI.id("redstone_control_module"), (stack, level, entity, seed) -> RedstoneControlModuleItem.isRequiresLowSignal(stack) ? 0.0f : 1.0f));
    }
}

