/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import quek.undergarden.recipe.InfusingBookCategory;
import quek.undergarden.recipe.InfusingRecipe;
import quek.undergarden.registry.UGRecipeSerializers;

public record ItemInfusingRecipe(InfusingBookCategory category, Ingredient infusableItems, int infusingTime, float experience) implements InfusingRecipe
{
    public boolean matches(SingleRecipeInput input, Level level) {
        return this.infusableItems().test(input.item());
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        return input.item().copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    @Override
    public InfusingRecipe.SlotType getRecipeSlotType() {
        return InfusingRecipe.SlotType.ROGDORIUM;
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{this.infusableItems()});
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)UGRecipeSerializers.ITEM_INFUSING.get();
    }

    public static class Serializer
    implements RecipeSerializer<ItemInfusingRecipe> {
        private static final MapCodec<ItemInfusingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)InfusingBookCategory.CODEC.optionalFieldOf("category", (Object)InfusingBookCategory.MISC).forGetter(recipe -> recipe.category), (App)Ingredient.CODEC_NONEMPTY.fieldOf("items").forGetter(recipe -> recipe.infusableItems), (App)Codec.INT.optionalFieldOf("infusing_time", (Object)200).forGetter(recipe -> recipe.infusingTime), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(recipe -> Float.valueOf(recipe.experience))).apply((Applicative)instance, ItemInfusingRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, ItemInfusingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec(InfusingBookCategory.CODEC), ItemInfusingRecipe::category, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ItemInfusingRecipe::infusableItems, (StreamCodec)ByteBufCodecs.INT, ItemInfusingRecipe::infusingTime, (StreamCodec)ByteBufCodecs.FLOAT, ItemInfusingRecipe::experience, ItemInfusingRecipe::new);

        public MapCodec<ItemInfusingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ItemInfusingRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }
    }
}

