/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import quek.undergarden.event.UthericInfectionEvents;
import quek.undergarden.registry.UGAttachments;
import quek.undergarden.registry.UGTags;

public class InfectionCommand {
    private static final SimpleCommandExceptionType CANNOT_INFECT = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.undergarden.infection.cannot_infect"));
    private static final SimpleCommandExceptionType CANNOT_INFECT_MULTIPLE = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.undergarden.infection.cannot_infect_multiple"));

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"infection").requires(cs -> cs.hasPermission(3))).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).then(Commands.literal((String)"set").then(Commands.argument((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0, (double)20.0)).executes(context -> InfectionCommand.applyInfection((CommandSourceStack)context.getSource(), EntityArgument.getEntities((CommandContext)context, (String)"targets"), DoubleArgumentType.getDouble((CommandContext)context, (String)"amount"))))));
    }

    private static int applyInfection(CommandSourceStack source, Collection<? extends Entity> targets, double amount) throws CommandSyntaxException {
        int skipped = 0;
        for (Entity entity : targets) {
            if (entity.getType().is(UGTags.Entities.IMMUNE_TO_INFECTION)) {
                ++skipped;
                continue;
            }
            entity.setData(UGAttachments.UTHERIC_INFECTION, (Object)amount);
            UthericInfectionEvents.sendInfectionSyncPacket(entity);
        }
        if (targets.size() == 1) {
            if (skipped > 0) {
                throw CANNOT_INFECT.create();
            }
            source.sendSuccess(() -> Component.translatable((String)"commands.undergarden.infection.success.single", (Object[])new Object[]{amount, ((Entity)targets.iterator().next()).getDisplayName()}), true);
        } else {
            if (skipped >= targets.size()) {
                throw CANNOT_INFECT_MULTIPLE.create();
            }
            int finalSkipped = skipped;
            source.sendSuccess(() -> Component.translatable((String)"commands.undergarden.infection.success.multiple", (Object[])new Object[]{amount, targets.size() - finalSkipped}), true);
            if (finalSkipped > 0) {
                source.sendSuccess(() -> Component.translatable((String)"commands.undergarden.infection.skipped", (Object[])new Object[]{finalSkipped}), true);
            }
        }
        return 1;
    }
}

