/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import quek.undergarden.registry.UGParticleTypes;

public class TotemBeamParticle
extends SimpleAnimatedParticle {
    private final Vec3 target;

    public TotemBeamParticle(ClientLevel level, SpriteSet sprites, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, Vec3 target) {
        super(level, x, y, z, sprites, 0.0f);
        this.quadSize = 0.15f;
        this.target = target;
        this.hasPhysics = true;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            int i = this.lifetime - this.age;
            double d0 = 1.0 / (double)i;
            this.x = Mth.lerp((double)d0, (double)this.x, (double)this.target.x());
            this.y = Mth.lerp((double)d0, (double)this.y, (double)this.target.y());
            this.z = Mth.lerp((double)d0, (double)this.z, (double)this.target.z());
        }
        this.setSpriteFromAge(this.sprites);
    }

    public record Options(Vec3 target, int duration) implements ParticleOptions
    {
        public static final MapCodec<Options> CODEC = RecordCodecBuilder.mapCodec(p_382882_ -> p_382882_.group((App)Vec3.CODEC.fieldOf("target").forGetter(Options::target), (App)ExtraCodecs.POSITIVE_INT.fieldOf("duration").forGetter(Options::duration)).apply((Applicative)p_382882_, Options::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Options> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.fromCodec((Codec)Vec3.CODEC), Options::target, (StreamCodec)ByteBufCodecs.VAR_INT, Options::duration, Options::new);

        public ParticleType<Options> getType() {
            return (ParticleType)UGParticleTypes.TOTEM_BEAM.get();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<Options> {
        private final SpriteSet sprite;

        public Provider(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(Options options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            TotemBeamParticle particle = new TotemBeamParticle(level, this.sprite, x, y, z, xSpeed, ySpeed, zSpeed, options.target());
            particle.setLifetime(options.duration());
            return particle;
        }
    }
}

