/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client.model;

import com.google.common.collect.ImmutableSet;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import quek.undergarden.entity.monster.stoneborn.Stoneborn;

public class StonebornModel<T extends Stoneborn>
extends ListModel<T> {
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public StonebornModel(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.leftArm = root.getChild("leftArm");
        this.rightArm = root.getChild("rightArm");
        this.leftLeg = root.getChild("leftLeg");
        this.rightLeg = root.getChild("rightLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -12.0f, -4.0f, 8.0f, 12.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(0, 20).addBox(-5.0f, -11.0f, -5.0f, 10.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(32, 8).addBox(-7.0f, -10.0f, 0.0f, 14.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 12).addBox(7.0f, -13.0f, 0.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 12).addBox(-9.0f, -15.0f, 0.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(48, 12).addBox(4.0f, -8.0f, 0.0f, 3.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)-1.0f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-2.0f, -1.0f, -2.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.75f, (float)-3.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition jaw = head.addOrReplaceChild("jaw", CubeListBuilder.create().texOffs(36, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-2.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 26).addBox(-6.0f, -7.0f, -4.0f, 12.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)1.0f));
        PartDefinition robe = body.addOrReplaceChild("robe", CubeListBuilder.create().texOffs(40, 21).addBox(-6.0f, -7.0f, -4.0f, 12.0f, 14.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(0, 48).addBox(-4.0f, -0.5f, -2.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-2.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0436f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(0, 48).mirror().addBox(-1.0f, -0.5f, -2.0f, 4.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)7.0f, (float)-2.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.0436f));
        PartDefinition leftLeg = partdefinition.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(16, 48).addBox(-3.0f, 0.0f, -1.0f, 5.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(70, 48).addBox(-3.0f, 0.0f, -1.0f, 5.0f, 15.0f, 4.0f, new CubeDeformation(0.24f)), PartPose.offset((float)-3.0f, (float)9.0f, (float)0.0f));
        PartDefinition rightLeg = partdefinition.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(16, 48).mirror().addBox(-2.0f, 0.0f, -1.0f, 5.0f, 15.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(70, 48).mirror().addBox(-2.0f, 0.0f, -1.0f, 5.0f, 15.0f, 4.0f, new CubeDeformation(0.24f)).mirror(false), PartPose.offset((float)3.0f, (float)9.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)88, (int)67);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightArm.zRot = -0.0436f;
        this.leftArm.zRot = 0.0436f;
        AnimationUtils.bobArms((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)ageInTicks);
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
    }

    public Iterable<ModelPart> parts() {
        return ImmutableSet.of((Object)this.head, (Object)this.body, (Object)this.leftArm, (Object)this.rightArm, (Object)this.leftLeg, (Object)this.rightLeg, (Object[])new ModelPart[0]);
    }
}

