/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGParticleTypes;

public class ShimmerweedBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<ShimmerweedBlock> CODEC = ShimmerweedBlock.simpleCodec(ShimmerweedBlock::new);
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0);

    public ShimmerweedBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean isValidBonemealTarget(LevelReader reader, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        DoublePlantBlock doubleplantblock = (DoublePlantBlock)UGBlocks.TALL_SHIMMERWEED.get();
        if (doubleplantblock.defaultBlockState().canSurvive((LevelReader)level, pos) && level.isEmptyBlock(pos.above())) {
            DoublePlantBlock.placeAt((LevelAccessor)level, (BlockState)doubleplantblock.defaultBlockState(), (BlockPos)pos, (int)2);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double x = (double)pos.getX() + (double)random.nextFloat();
        double y = (double)pos.getY() + 0.2 + (double)random.nextFloat();
        double z = (double)pos.getZ() + (double)random.nextFloat();
        double xSpeed = (double)random.nextFloat() * -0.9 * (double)random.nextFloat();
        double zSpeed = (double)random.nextFloat() * -0.9 * (double)random.nextFloat();
        level.addParticle((ParticleOptions)UGParticleTypes.SHIMMER.get(), x, y, z, xSpeed, 0.0, zSpeed);
    }
}

