/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import quek.undergarden.registry.UGDamageSources;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGTags;

public class ShardTorchBlock
extends TorchBlock {
    public ShardTorchBlock(BlockBehaviour.Properties properties) {
        super(ParticleTypes.FLAME, properties);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.7;
        double z = (double)pos.getZ() + 0.5;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)UGParticleTypes.SHARD.get(), x, y, z, 0.0, 0.0, 0.0);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.scheduleTick(pos, (Block)this, 20);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(4.0), entity -> entity.getType().is(UGTags.Entities.ROTSPAWN)).forEach(entity -> {
            if (entity.hurt(UGDamageSources.getShardTorchDamage((Level)level, pos.getCenter()), 4.0f)) {
                ShardTorchBlock.drawParticlesTo(level, pos.getCenter(), (Entity)entity);
            }
        });
        level.scheduleTick(pos, (Block)this, 20);
    }

    public static void drawParticlesTo(ServerLevel level, Vec3 torchPos, Entity highlight) {
        int particles = (int)Math.min(12L, Math.round(torchPos.distanceToSqr(highlight.position())));
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            double x = torchPos.x() + (highlight.position().x() - torchPos.x()) * trailFactor + (double)level.getRandom().nextFloat() * 0.25;
            double y = torchPos.y() + 0.25 + (highlight.getEyeY() - torchPos.y()) * trailFactor + (double)level.getRandom().nextFloat() * 0.25;
            double z = torchPos.z() + (highlight.position().z() - torchPos.z()) * trailFactor + (double)level.getRandom().nextFloat() * 0.25;
            level.sendParticles((ParticleOptions)((SimpleParticleType)UGParticleTypes.SHARD_BEAM.get()), x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

