/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import quek.undergarden.registry.UGParticleTypes;

public class EngorgedCapBlock
extends Block {
    public EngorgedCapBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.getRandom().nextInt(15) == 0) {
            this.trySpawnDripParticles(level, pos, state);
        }
    }

    private void trySpawnDripParticles(Level level, BlockPos pos, BlockState state) {
        VoxelShape voxelshape;
        double d0;
        if (state.getFluidState().isEmpty() && !(level.getRandom().nextFloat() < 0.3f) && (d0 = (voxelshape = state.getCollisionShape((BlockGetter)level, pos)).max(Direction.Axis.Y)) >= 1.0 && !state.is(BlockTags.IMPERMEABLE)) {
            double d1 = voxelshape.min(Direction.Axis.Y);
            if (d1 > 0.0) {
                this.spawnParticle(level, pos, voxelshape, (double)pos.getY() + d1 - 0.1);
            } else {
                BlockPos blockpos = pos.below();
                BlockState blockstate = level.getBlockState(blockpos);
                VoxelShape voxelshape1 = blockstate.getCollisionShape((BlockGetter)level, blockpos);
                double d2 = voxelshape1.max(Direction.Axis.Y);
                if ((d2 < 1.0 || !blockstate.isCollisionShapeFullBlock((BlockGetter)level, blockpos)) && blockstate.getFluidState().isEmpty()) {
                    this.spawnParticle(level, pos, voxelshape, (double)pos.getY() - 0.1);
                }
            }
        }
    }

    private void spawnParticle(Level level, BlockPos pos, VoxelShape shape, double y) {
        this.spawnFluidParticle(level, (double)pos.getX() + shape.min(Direction.Axis.X), (double)pos.getX() + shape.max(Direction.Axis.X), (double)pos.getZ() + shape.min(Direction.Axis.Z), (double)pos.getZ() + shape.max(Direction.Axis.Z), y);
    }

    private void spawnFluidParticle(Level level, double x1, double x2, double z1, double z2, double y) {
        level.addParticle((ParticleOptions)UGParticleTypes.DRIPPING_BLOOD.get(), Mth.lerp((double)level.getRandom().nextDouble(), (double)x1, (double)x2), y, Mth.lerp((double)level.getRandom().nextDouble(), (double)z1, (double)z2), 0.0, 0.0, 0.0);
    }
}

