/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CloggrumLanternBlock
extends FaceAttachedHorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<CloggrumLanternBlock> CODEC = CloggrumLanternBlock.simpleCodec(CloggrumLanternBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape FLOOR_SHAPE = Shapes.or((VoxelShape)Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)3.0, (double)9.0), (VoxelShape)Block.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0));
    private static final VoxelShape CEILING_SHAPE = Shapes.or((VoxelShape)Block.box((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)Block.box((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0));
    private static final VoxelShape NORTH_WALL_SHAPE = Shapes.or((VoxelShape)Block.box((double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)3.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.box((double)7.0, (double)0.0, (double)11.0, (double)9.0, (double)2.0, (double)16.0), Block.box((double)4.0, (double)3.0, (double)6.0, (double)12.0, (double)13.0, (double)14.0)});
    private static final VoxelShape WEST_WALL_SHAPE = Shapes.or((VoxelShape)Block.box((double)9.0, (double)0.0, (double)7.0, (double)11.0, (double)3.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)11.0, (double)0.0, (double)7.0, (double)16.0, (double)2.0, (double)9.0), Block.box((double)6.0, (double)3.0, (double)4.0, (double)14.0, (double)13.0, (double)12.0)});
    private static final VoxelShape SOUTH_WALL_SHAPE = Shapes.or((VoxelShape)Block.box((double)7.0, (double)0.0, (double)5.0, (double)9.0, (double)3.0, (double)7.0), (VoxelShape[])new VoxelShape[]{Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)2.0, (double)5.0), Block.box((double)4.0, (double)3.0, (double)2.0, (double)12.0, (double)13.0, (double)10.0)});
    private static final VoxelShape EAST_WALL_SHAPE = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)7.0, (double)7.0, (double)3.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)7.0, (double)5.0, (double)2.0, (double)9.0), Block.box((double)2.0, (double)3.0, (double)4.0, (double)10.0, (double)13.0, (double)12.0)});

    public CloggrumLanternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACE, (Comparable)AttachFace.FLOOR)).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = CloggrumLanternBlock.getConnectedDirection((BlockState)state).getOpposite();
        return Block.canSupportCenter((LevelReader)level, (BlockPos)pos.relative(direction), (Direction)direction.getOpposite());
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch (CloggrumLanternBlock.getConnectedDirection((BlockState)state)) {
            default: {
                return CEILING_SHAPE;
            }
            case UP: {
                return FLOOR_SHAPE;
            }
            case NORTH: {
                return NORTH_WALL_SHAPE;
            }
            case EAST: {
                return EAST_WALL_SHAPE;
            }
            case SOUTH: {
                return SOUTH_WALL_SHAPE;
            }
            case WEST: 
        }
        return WEST_WALL_SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACE, FACING, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockstate = direction.getAxis() == Direction.Axis.Y ? (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection()) : (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)direction.getOpposite());
            if (!blockstate.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return (BlockState)blockstate.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        return null;
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return CloggrumLanternBlock.getConnectedDirection((BlockState)state).getOpposite() == facing && !state.canSurvive((LevelReader)level, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, level, pos, facingPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

