/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.compat.xnet;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mcjty.rftoolsstorage.compat.xnet.StorageChannelSettings;
import mcjty.rftoolsstorage.compat.xnet.XNetSupport;
import mcjty.rftoolsstorage.modules.scanner.tools.InventoryAccessSettings;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class StorageConnectorSettings
extends AbstractConnectorSettings {
    public static final String TAG_MODE = "mode";
    public static final String TAG_BIGUI = "bigui";
    public static final String TAG_BIAUTO = "biauto";
    public static final String TAG_BISCREEN = "biscreen";
    public static final String TAG_BOGUI = "bogui";
    public static final String TAG_BOAUTO = "boauto";
    public static final String TAG_BOSCREEN = "boscreen";
    public static final String TAG_FILTER = "flt";
    public static final String TAG_BLACKLIST = "blacklist";
    public static final String TAG_NBT = "nbt";
    public static final String TAG_META = "meta";
    private Mode mode = Mode.INVENTORY;
    private InventoryAccessSettings accessSettings = new InventoryAccessSettings();
    public static final MapCodec<StorageConnectorSettings> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AbstractConnectorSettings.BaseSettings.CODEC.fieldOf("base").forGetter(settings -> settings.settings), (App)InventoryAccessSettings.CODEC.fieldOf("as").forGetter(settings -> settings.accessSettings), (App)Mode.CODEC.fieldOf(TAG_MODE).forGetter(settings -> settings.mode)).apply((Applicative)instance, StorageConnectorSettings::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, StorageConnectorSettings> STREAM_CODEC = StreamCodec.composite((StreamCodec)AbstractConnectorSettings.BaseSettings.STREAM_CODEC, settings -> settings.settings, InventoryAccessSettings.STREAM_CODEC, settings -> settings.accessSettings, Mode.STREAM_CODEC, settings -> settings.mode, StorageConnectorSettings::new);

    public StorageConnectorSettings(@Nonnull Direction side) {
        super(AbstractConnectorSettings.DEFAULT_SETTINGS, side);
    }

    public Mode getMode() {
        return this.mode;
    }

    public InventoryAccessSettings getAccessSettings() {
        return this.accessSettings;
    }

    public StorageConnectorSettings(AbstractConnectorSettings.BaseSettings baseSettings, InventoryAccessSettings accessSettings, Mode mode) {
        super(baseSettings, Direction.NORTH);
        this.accessSettings = accessSettings;
        this.mode = mode;
    }

    public IChannelType getType() {
        return XNetSupport.storageChannelType;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch (this.mode.ordinal()) {
            case 0: {
                boolean inputBlocked = this.accessSettings.inputBlocked();
                boolean outputBlocked = this.accessSettings.outputBlocked();
                if (inputBlocked && outputBlocked) {
                    return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 13, 75, 13, 10);
                }
                if (inputBlocked) {
                    return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 13, 48, 13, 10);
                }
                if (outputBlocked) {
                    return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 0, 48, 13, 10);
                }
                return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 13, 57, 13, 10);
            }
            case 1: {
                return new IndicatorIcon(StorageChannelSettings.iconGuiElements, 13, 66, 13, 10);
            }
        }
        return null;
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        if (tag.equals("facing")) {
            return this.advanced;
        }
        return true;
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        this.sideGui(gui);
        gui.shift(30).choices(TAG_MODE, "Set to 'inventory' or 'storage'", (Enum)this.mode, (Enum[])Mode.values());
        if (this.mode == Mode.INVENTORY) {
            gui.nl().label("Input ").shift(12).label("UI").toggle(TAG_BIGUI, "Block input from scanner UI", this.accessSettings.isBlockInputGui()).label("Auto").toggle(TAG_BIAUTO, "Block input from automation", this.accessSettings.isBlockInputAuto()).label("Scr").toggle(TAG_BISCREEN, "Block input from screens", this.accessSettings.isBlockInputScreen());
            gui.nl().label("Output").shift(10).label("UI").toggle(TAG_BOGUI, "Block extraction from scanner UI", this.accessSettings.isBlockOutputGui()).label("Auto").toggle(TAG_BOAUTO, "Block extraction from automation", this.accessSettings.isBlockOutputAuto()).label("Scr").toggle(TAG_BOSCREEN, "Block extraction from screens", this.accessSettings.isBlockOutputScreen());
            gui.nl().toggleText(TAG_BLACKLIST, "Enable blacklist mode", "BL", this.accessSettings.isBlacklist()).shift(2).toggleText(TAG_META, "Metadata matching", "Meta", this.accessSettings.isMetaMode()).shift(2).toggleText(TAG_NBT, "NBT matching", "NBT", this.accessSettings.isNbtMode()).nl();
            for (int i = 0; i < 18; ++i) {
                gui.ghostSlot(TAG_FILTER + i, (ItemStack)this.accessSettings.getFilters().get(i));
            }
        }
    }

    private static boolean toBool(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.mode = Mode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
        this.accessSettings.setBlockInputGui(StorageConnectorSettings.toBool(data.get(TAG_BIGUI)));
        this.accessSettings.setBlockInputAuto(StorageConnectorSettings.toBool(data.get(TAG_BIAUTO)));
        this.accessSettings.setBlockInputScreen(StorageConnectorSettings.toBool(data.get(TAG_BISCREEN)));
        this.accessSettings.setBlockOutputGui(StorageConnectorSettings.toBool(data.get(TAG_BOGUI)));
        this.accessSettings.setBlockOutputAuto(StorageConnectorSettings.toBool(data.get(TAG_BOAUTO)));
        this.accessSettings.setBlockOutputScreen(StorageConnectorSettings.toBool(data.get(TAG_BOSCREEN)));
        for (int i = 0; i < 18; ++i) {
            this.accessSettings.getFilters().set(i, (Object)((ItemStack)data.get(TAG_FILTER + i)));
        }
        this.accessSettings.setMetaMode(StorageConnectorSettings.toBool(data.get(TAG_META)));
        this.accessSettings.setNbtMode(StorageConnectorSettings.toBool(data.get(TAG_NBT)));
        this.accessSettings.setBlacklist(StorageConnectorSettings.toBool(data.get(TAG_BLACKLIST)));
    }

    public static enum Mode implements StringRepresentable
    {
        INVENTORY,
        STORAGE;

        public static final Codec<Mode> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Mode> STREAM_CODEC;

        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Mode.class);
        }
    }
}

