/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.apps;

import com.mojang.authlib.GameProfile;
import earth.terrarium.tempad.api.app.TempadApp;
import earth.terrarium.tempad.api.context.SyncableContext;
import earth.terrarium.tempad.api.locations.TempadLocations;
import earth.terrarium.tempad.api.tva_device.ChrononHandler;
import earth.terrarium.tempad.api.tva_device.ChrononHandlerKt;
import earth.terrarium.tempad.api.tva_device.UpgradeHandler;
import earth.terrarium.tempad.api.tva_device.UpgradeHandlerKt;
import earth.terrarium.tempad.common.apps.PortalSetupData;
import earth.terrarium.tempad.common.registries.ModAttachmentsKt;
import earth.terrarium.tempad.common.registries.ModComponentsKt;
import earth.terrarium.tempad.common.registries.ModMenus;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0013\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\r\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0004H\u00c6\u0003J\u0017\u0010\u0018\u001a\u00020\u00002\f\b\u0002\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\fH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Learth/terrarium/tempad/common/apps/PortalSetupApp;", "Learth/terrarium/tempad/api/app/TempadApp;", "Learth/terrarium/tempad/common/apps/PortalSetupData;", "ctx", "Learth/terrarium/tempad/api/context/SyncableContext;", "<init>", "(Learth/terrarium/tempad/api/context/SyncableContext;)V", "getCtx", "()Learth/terrarium/tempad/api/context/SyncableContext;", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "pContainerId", "", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "player", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "createContent", "Lnet/minecraft/server/level/ServerPlayer;", "isEnabled", "", "component1", "copy", "equals", "other", "", "hashCode", "toString", "", "tempad-1.21.1"})
public final class PortalSetupApp
implements TempadApp<PortalSetupData> {
    @NotNull
    private final SyncableContext<?> ctx;

    public PortalSetupApp(@NotNull SyncableContext<?> ctx2) {
        Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
        this.ctx = ctx2;
    }

    @NotNull
    public final SyncableContext<?> getCtx() {
        return this.ctx;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory inventory, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Optional<PortalSetupData> optional = Optional.of(this.createContent((ServerPlayer)player));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return new ModMenus.PortalSetupMenu(pContainerId, inventory, optional);
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = Component.translatable((String)"app.tempad.portal_setup");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public PortalSetupData createContent(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        GameProfile gameProfile = ModComponentsKt.getOwner((MutableDataComponentHolder)this.ctx.getStack());
        if (gameProfile == null) {
            gameProfile = player.getGameProfile();
        }
        GameProfile profile = gameProfile;
        Intrinsics.checkNotNull((Object)profile);
        UpgradeHandler upgradeHandler = UpgradeHandlerKt.getUpgrades(this.ctx.getStack());
        Intrinsics.checkNotNull((Object)upgradeHandler);
        ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(this.ctx.getStack());
        Intrinsics.checkNotNull((Object)chrononHandler);
        return new PortalSetupData(TempadLocations.get(profile, upgradeHandler, chrononHandler), ModAttachmentsKt.getPinnedPosition((AttachmentHolder)player), this.ctx.getHolder());
    }

    @Override
    public boolean isEnabled(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    @NotNull
    public final SyncableContext<?> component1() {
        return this.ctx;
    }

    @NotNull
    public final PortalSetupApp copy(@NotNull SyncableContext<?> ctx2) {
        Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
        return new PortalSetupApp(ctx2);
    }

    public static /* synthetic */ PortalSetupApp copy$default(PortalSetupApp portalSetupApp, SyncableContext syncableContext, int n, Object object) {
        if ((n & 1) != 0) {
            syncableContext = portalSetupApp.ctx;
        }
        return portalSetupApp.copy(syncableContext);
    }

    @NotNull
    public String toString() {
        return "PortalSetupApp(ctx=" + this.ctx + ")";
    }

    public int hashCode() {
        return this.ctx.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PortalSetupApp)) {
            return false;
        }
        PortalSetupApp portalSetupApp = (PortalSetupApp)other;
        return Intrinsics.areEqual(this.ctx, portalSetupApp.ctx);
    }
}

