/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.client.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.tempad.api.context.ContextHolder;
import earth.terrarium.tempad.client.widgets.TimelineEntry;
import earth.terrarium.tempad.common.data.HistoricalLocation;
import earth.terrarium.tempad.common.network.c2s.BackTrackLocation;
import earth.terrarium.tempad.common.utils.ExtensionsKt;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2f;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010'\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B'\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J \u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0012H\u0002J(\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0012H\u0002R\u0015\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR5\u0010\f\u001a)\u0012%\u0012#\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u00050\u00050\u000e\u00a2\u0006\u0002\b\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Learth/terrarium/tempad/client/screen/TimeTwisterScreen;", "Lnet/minecraft/client/gui/screens/Screen;", "history", "", "Ljava/util/Date;", "Learth/terrarium/tempad/common/data/HistoricalLocation;", "ctx", "Learth/terrarium/tempad/api/context/ContextHolder;", "<init>", "(Ljava/util/Map;Learth/terrarium/tempad/api/context/ContextHolder;)V", "getCtx", "()Learth/terrarium/tempad/api/context/ContextHolder;", "locations", "", "", "kotlin.jvm.PlatformType", "Lkotlin/jvm/internal/EnhancedNullability;", "getIndex", "", "isPauseScreen", "", "mouseClicked", "mouseX", "", "mouseY", "button", "keyReleased", "keyCode", "scanCode", "modifiers", "select", "index", "render", "", "graphics", "Lnet/minecraft/client/gui/GuiGraphics;", "partialTicks", "", "getTextColor", "Companion", "tempad-1.21.1"})
@SourceDebugExtension(value={"SMAP\nTimeTwisterScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeTwisterScreen.kt\nearth/terrarium/tempad/client/screen/TimeTwisterScreen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1#2:227\n*E\n"})
public final class TimeTwisterScreen
extends Screen {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ContextHolder<?> ctx;
    @NotNull
    private final List<Map.Entry<Date, HistoricalLocation>> locations;
    private static final int MAX_ENTRIES = 8;
    private static final int START = 25;
    private static final int END = 80;
    private static final int END_HOVERED = 85;
    private static final float TEXT_LENGTH = 42.0f;
    private static final float TEXT_LENGTH_HOVERED = 44.0f;
    private static final float ICON_LENGTH = 60.375f;
    private static final float ICON_LENGTH_HOVERED = 63.25f;
    private static final int TEXT_COLOR = 0xAAAAAA;
    private static final int TEXT_COLOR_DISABLED = 0xFF5555;
    private static final float COLOR = 0.2f;
    private static final float COLOR_ODD = 0.25f;
    private static final float COLOR_HOVER = 1.2f;
    private static final float COLOR_ODD_HOVER = 1.25f;
    private static long lastSelect;

    public TimeTwisterScreen(@NotNull Map<Date, HistoricalLocation> history, @NotNull ContextHolder<?> ctx2) {
        Intrinsics.checkNotNullParameter(history, (String)"history");
        Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
        super(CommonComponents.EMPTY);
        this.ctx = ctx2;
        Set set = MapsKt.toSortedMap(history).entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        this.locations = CollectionsKt.reversed((Iterable)CollectionsKt.toList((Iterable)set));
    }

    @NotNull
    public final ContextHolder<?> getCtx() {
        return this.ctx;
    }

    private final int getIndex() {
        Minecraft minecraft = this.minecraft;
        if (minecraft != null) {
            Minecraft mc = minecraft;
            boolean bl = false;
            Window window = mc.getWindow();
            MouseHandler mouse = mc.mouseHandler;
            double mdx = 0.0;
            double mdy = 0.0;
            double minRadius = 0.0;
            if (Minecraft.ON_OSX) {
                mdx = mouse.xpos() - (double)((float)window.getWidth() / 4.0f);
                mdy = mouse.ypos() - (double)((float)window.getHeight() / 4.0f);
                minRadius = window.getGuiScale() * (double)25 / (double)2;
            } else {
                mdx = mouse.xpos() - (double)((float)window.getWidth() / 2.0f);
                mdy = mouse.ypos() - (double)((float)window.getHeight() / 2.0f);
                minRadius = window.getGuiScale() * (double)25;
            }
            if (mdx * mdx + mdy * mdy < minRadius * minRadius) {
                return -1;
            }
            float angle = (float)Math.toDegrees(Math.atan2(mdx, -mdy));
            if (angle < 0.0f) {
                angle += (float)360;
            }
            return Companion.indexFromAngle(angle);
        }
        return -1;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return button == 0 ? this.select(this.getIndex()) : super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return switch (keyCode) {
            case 49 -> this.select(0);
            case 50 -> this.select(1);
            case 51 -> this.select(2);
            case 52 -> this.select(3);
            case 53 -> this.select(4);
            case 54 -> this.select(5);
            case 55 -> this.select(6);
            case 56 -> this.select(7);
            default -> false;
        };
    }

    private final boolean select(int index) {
        Map.Entry entry = (Map.Entry)CollectionsKt.getOrNull(this.locations, (int)index);
        if (entry != null) {
            Map.Entry entry2 = entry;
            boolean bl = false;
            Date date = (Date)entry2.getKey();
            Intrinsics.checkNotNull((Object)date);
            ExtensionsKt.sendToServer((Packet)new BackTrackLocation(date, this.ctx));
        }
        this.onClose();
        lastSelect = System.currentTimeMillis();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        super.render(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        int hoveredIndex = this.getIndex();
        int scaledHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        int scaledWidth = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        float middleX = (float)scaledWidth / 2.0f;
        float middleY = (float)scaledHeight / 2.0f;
        for (int angle = 0; angle < 360; ++angle) {
            int index = Companion.indexFromAngle(angle);
            boolean hovered = hoveredIndex == index && index < this.locations.size();
            int length = hovered ? 85 : 80;
            float color = index % 2 == 0 ? (hovered ? 1.2f : 0.2f) : (hovered ? 1.25f : 0.25f);
            double radians1 = Math.toRadians(angle);
            double radians2 = Math.toRadians(angle + 1);
            float x1 = (float)Math.sin(radians1);
            float y1 = -((float)Math.cos(radians1));
            float x2 = (float)Math.sin(radians2);
            float y2 = -((float)Math.cos(radians2));
            Intrinsics.checkNotNull((Object)builder);
            Companion.drawXYRGBA(builder, middleX + x1 * (float)length, middleY + y1 * (float)length, color, color, color, 0.8f);
            Companion.drawXYRGBA(builder, middleX + x2 * (float)length, middleY + y2 * (float)length, color, color, color, 0.8f);
            Companion.drawXYRGBA(builder, middleX + x2 * (float)25, middleY + y2 * (float)25, color, color, color, 0.56f);
            Companion.drawXYRGBA(builder, middleX + x1 * (float)25, middleY + y1 * (float)25, color, color, color, 0.56f);
            float innerColor = index % 2 == 0 ? 1.0f : 0.5f;
            int start = length - 2;
            Companion.drawXYRGBA(builder, middleX + x1 * (float)length, middleY + y1 * (float)length, innerColor, innerColor, innerColor, 1.0f);
            Companion.drawXYRGBA(builder, middleX + x2 * (float)length, middleY + y2 * (float)length, innerColor, innerColor, innerColor, 1.0f);
            Companion.drawXYRGBA(builder, middleX + x2 * (float)start, middleY + y2 * (float)start, innerColor, innerColor, innerColor, 1.0f);
            Companion.drawXYRGBA(builder, middleX + x1 * (float)start, middleY + y1 * (float)start, innerColor, innerColor, innerColor, 1.0f);
        }
        MeshData meshData = builder.build();
        if (meshData != null) {
            MeshData it = meshData;
            boolean bl = false;
            BufferUploader.drawWithShader((MeshData)it);
        }
        for (int index = 0; index < 8; ++index) {
            void $this$render_u24lambda_u243;
            MutableComponent mutableComponent;
            Map.Entry<Date, HistoricalLocation> entry;
            boolean hovered = hoveredIndex == index && index < this.locations.size();
            float angle = Companion.angleFromIndex(index);
            Vector2f pos = Companion.toPoint(angle, hovered ? 44.0f : 42.0f);
            graphics.drawCenteredString(this.font, String.valueOf(index + 1), (int)((float)scaledWidth / 2.0f + pos.x()), (int)((float)scaledHeight / 2.0f + pos.y()), this.getTextColor(index));
            pos = Companion.toPoint(angle, hovered ? 63.25f : 60.375f);
            if (index >= this.locations.size()) continue;
            Intrinsics.checkNotNullExpressionValue(this.locations.get(index), (String)"get(...)");
            Date date = entry.getKey();
            HistoricalLocation history = entry.getValue();
            ResourceLocation resourceLocation = history.getMarker();
            Intrinsics.checkNotNull((Object)resourceLocation);
            graphics.blitSprite(ResourceLocation.fromNamespaceAndPath((String)resourceLocation.getNamespace(), (String)("marker/" + history.getMarker().getPath())), (int)((float)scaledWidth / 2.0f + pos.x() - (float)8), (int)((float)scaledHeight / 2.0f + pos.y() - (float)8), 16, 16);
            if (!hovered) continue;
            Object[] objectArray = new FormattedCharSequence[3];
            MutableComponent x1 = mutableComponent = Component.translatable((String)history.getMarker().toLanguageKey("marker"));
            int n = 0;
            Object[] objectArray2 = objectArray;
            TimeTwisterScreen timeTwisterScreen = this;
            boolean bl = false;
            $this$render_u24lambda_u243.append(CommonComponents.SPACE);
            $this$render_u24lambda_u243.append((Component)ExtensionsKt.getComponent(history.getDimension()));
            Unit unit = Unit.INSTANCE;
            objectArray2[n] = mutableComponent.getVisualOrderText();
            objectArray[1] = ExtensionsKt.getComponent(history.getPos()).getVisualOrderText();
            objectArray[2] = Component.literal((String)TimelineEntry.Companion.getDateFormat().format(date)).getVisualOrderText();
            timeTwisterScreen.setTooltipForNextRenderPass(CollectionsKt.listOf((Object[])objectArray));
        }
    }

    private final int getTextColor(int index) {
        return index >= this.locations.size() ? 0xFF5555 : 0xAAAAAA;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nJ\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0005J>\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006+"}, d2={"Learth/terrarium/tempad/client/screen/TimeTwisterScreen$Companion;", "", "<init>", "()V", "MAX_ENTRIES", "", "START", "END", "END_HOVERED", "TEXT_LENGTH", "", "TEXT_LENGTH_HOVERED", "ICON_LENGTH", "ICON_LENGTH_HOVERED", "TEXT_COLOR", "TEXT_COLOR_DISABLED", "COLOR", "COLOR_ODD", "COLOR_HOVER", "COLOR_ODD_HOVER", "lastSelect", "", "getLastSelect", "()J", "setLastSelect", "(J)V", "toPoint", "Lorg/joml/Vector2f;", "angle", "length", "indexFromAngle", "angleFromIndex", "index", "drawXYRGBA", "", "builder", "Lcom/mojang/blaze3d/vertex/BufferBuilder;", "x", "y", "r", "g", "b", "a", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final long getLastSelect() {
            return lastSelect;
        }

        public final void setLastSelect(long l) {
            lastSelect = l;
        }

        @NotNull
        public final Vector2f toPoint(float angle, float length) {
            float radians = (float)Math.toRadians(angle);
            float x = Mth.sin((float)radians) * length;
            float y = -Mth.cos((float)radians) * length;
            return new Vector2f(x, y);
        }

        public final int indexFromAngle(float angle) {
            return Math.round(angle * (float)8 / 360.0f) % 8;
        }

        public final float angleFromIndex(int index) {
            return 45.0f * (float)index;
        }

        public final void drawXYRGBA(@NotNull BufferBuilder builder, float x, float y, float r, float g, float b, float a) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            builder.addVertex(x, y, 0.0f).setColor(r, g, b, a);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

