/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.item.component;

import com.buuz135.functionalstorage.block.tile.ControllableDrawerTile;
import com.buuz135.functionalstorage.item.component.FunctionalUpgradeBehavior;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public record GenerateItemBehavior(ItemStack item) implements FunctionalUpgradeBehavior
{
    public static final MapCodec<GenerateItemBehavior> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)ItemStack.STRICT_CODEC.fieldOf("item").forGetter(GenerateItemBehavior::item)).apply((Applicative)in, GenerateItemBehavior::new));

    @Override
    public void work(Level level, BlockPos pos, ControllableDrawerTile<?> drawer, ItemStack upgradeStack, int upgradeSlot) {
        IItemHandler capability = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)Direction.UP);
        if (capability != null) {
            ItemHandlerHelper.insertItem((IItemHandler)capability, (ItemStack)this.item.copy(), (boolean)false);
        }
    }

    @Override
    public MapCodec<? extends FunctionalUpgradeBehavior> codec() {
        return CODEC;
    }

    @Override
    public List<Component> getTooltip() {
        List<Component> list = FunctionalUpgradeBehavior.super.getTooltip();
        list.add((Component)Component.translatable((String)"functionalupgrade.desc.generate_item", (Object[])new Object[]{this.item.getCount(), Component.translatable((String)this.item.getDescriptionId())}));
        return list;
    }
}

