/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.util;

import com.blakebr0.mysticalagriculture.api.MysticalAgricultureDataComponentTypes;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ExperienceCapsuleUtils {
    public static final int MAX_XP_POINTS = 1200;

    public static DataComponentMap makeComponentMap(int xp) {
        return DataComponentMap.builder().set(MysticalAgricultureDataComponentTypes.EXPERIENCE_CAPSULE, (Object)Math.min(1200, xp)).build();
    }

    public static ItemStack getExperienceCapsule(int xp, Item item) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.set(MysticalAgricultureDataComponentTypes.EXPERIENCE_CAPSULE, (Object)xp);
        return stack;
    }

    public static int getExperience(ItemStack stack) {
        Integer component = (Integer)stack.get(MysticalAgricultureDataComponentTypes.EXPERIENCE_CAPSULE);
        if (component != null) {
            return component;
        }
        return 0;
    }

    public static int addExperienceToCapsule(ItemStack stack, int amount) {
        int xp = ExperienceCapsuleUtils.getExperience(stack);
        if (xp >= 1200) {
            return amount;
        }
        int newAmount = Math.min(1200, xp + amount);
        stack.set(MysticalAgricultureDataComponentTypes.EXPERIENCE_CAPSULE, (Object)newAmount);
        return Math.max(0, amount - (newAmount - xp));
    }

    public static int removeExperienceFromCapsule(ItemStack stack, int amount) {
        int xp = ExperienceCapsuleUtils.getExperience(stack);
        int newAmount = Math.max(0, xp - amount);
        stack.set(MysticalAgricultureDataComponentTypes.EXPERIENCE_CAPSULE, (Object)newAmount);
        return Math.max(0, amount - xp);
    }
}

