/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.goals;

import com.telepathicgrunt.the_bumblezone.entities.controllers.HoneySlimeMoveController;
import com.telepathicgrunt.the_bumblezone.entities.mobs.HoneySlimeEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;

public class HoneySlimeBreedGoal
extends Goal {
    private static final TargetingConditions TARGETING_CONDITIONS = TargetingConditions.forCombat().range(8.0).ignoreLineOfSight();
    protected final HoneySlimeEntity slime;
    private final Class<? extends Animal> mateClass;
    protected final Level world;
    protected Animal nearbyMate;
    private int spawnBabyDelay;

    public HoneySlimeBreedGoal(HoneySlimeEntity honeySlimeEntity, double speedIn) {
        this(honeySlimeEntity, speedIn, ((Object)((Object)honeySlimeEntity)).getClass());
    }

    public HoneySlimeBreedGoal(HoneySlimeEntity honeySlimeEntity, double speedIn, Class<? extends Animal> mateClass) {
        this.slime = honeySlimeEntity;
        this.world = honeySlimeEntity.level();
        this.mateClass = mateClass;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (!this.slime.isInLove()) {
            return false;
        }
        this.nearbyMate = this.getNearbyMate();
        return this.nearbyMate != null && this.slime.getMoveControl() instanceof HoneySlimeMoveController;
    }

    public boolean canContinueToUse() {
        return this.nearbyMate.isAlive() && this.nearbyMate.isInLove() && this.spawnBabyDelay < 60;
    }

    public void stop() {
        this.nearbyMate = null;
        this.spawnBabyDelay = 0;
    }

    public void tick() {
        this.slime.getLookControl().setLookAt((Entity)this.nearbyMate, 10.0f, (float)this.slime.getMaxHeadXRot());
        this.slime.lookAt((Entity)this.nearbyMate, 10.0f, 10.0f);
        ((HoneySlimeMoveController)this.slime.getMoveControl()).setDirection(this.slime.getYRot(), true);
        ((HoneySlimeMoveController)this.slime.getMoveControl()).setSpeed(1.0);
        ++this.spawnBabyDelay;
        if (this.spawnBabyDelay >= 60 && this.slime.distanceToSqr((Entity)this.nearbyMate) < 9.0) {
            this.spawnBaby();
        }
    }

    private Animal getNearbyMate() {
        List list = this.world.getNearbyEntities(this.mateClass, TARGETING_CONDITIONS, (LivingEntity)this.slime, this.slime.getBoundingBox().inflate(8.0));
        double d0 = Double.MAX_VALUE;
        Animal animalentity = null;
        for (Animal animalentity1 : list) {
            if (!this.slime.canMate(animalentity1) || !(this.slime.distanceToSqr((Entity)animalentity1) < d0)) continue;
            animalentity = animalentity1;
            d0 = this.slime.distanceToSqr((Entity)animalentity1);
        }
        return animalentity;
    }

    protected void spawnBaby() {
        this.slime.spawnChildFromBreeding((ServerLevel)this.world, this.nearbyMate);
    }
}

