/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.blocks.ProperFacingBlock;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class HoneycombBrood
extends ProperFacingBlock {
    public static final MapCodec<HoneycombBrood> CODEC = Block.simpleCodec(HoneycombBrood::new);
    public static final IntegerProperty STAGE = BlockStateProperties.AGE_3;

    public HoneycombBrood() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_ORANGE).instrument(NoteBlockInstrument.BANJO).randomTicks().strength(0.5f, 0.5f).sound(SoundType.CORAL_BLOCK).speedFactor(0.8f));
    }

    public HoneycombBrood(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public MapCodec<? extends HoneycombBrood> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, STAGE});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos position, Player playerEntity, InteractionHand playerHand, BlockHitResult raytraceResult) {
        RandomSource random = playerEntity.getRandom();
        if (itemStack.getItem() == Items.GLASS_BOTTLE) {
            GeneralUtils.givePlayerItem(playerEntity, playerHand, new ItemStack((ItemLike)Items.HONEY_BOTTLE), false, true);
            int stage = (Integer)blockState.getValue((Property)STAGE);
            HoneycombBrood.spawnBroodMob(level, random, blockState, position, stage);
            level.setBlock(position, (BlockState)((Block)BzBlocks.EMPTY_HONEYCOMB_BROOD.get()).defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)((Direction)blockState.getValue((Property)BlockStateProperties.FACING))), 3);
            if ((level.dimension().equals(BzDimension.BZ_WORLD_KEY) || BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) && !playerEntity.isCreative() && !playerEntity.isSpectator() && BzBeeAggressionConfigs.aggressiveBees && level.getDifficulty() != Difficulty.PEACEFUL) {
                ServerPlayer serverPlayer;
                Registry mobEffects = level.registryAccess().registryOrThrow(Registries.MOB_EFFECT);
                if (playerEntity instanceof ServerPlayer && !EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)playerEntity)) {
                    Holder.Reference wrathOfTheHiveEffectHolder = (Holder.Reference)mobEffects.getHolder(BzEffects.WRATH_OF_THE_HIVE.getId()).get();
                    if (playerEntity.hasEffect((Holder)wrathOfTheHiveEffectHolder)) {
                        playerEntity.removeEffect((Holder)wrathOfTheHiveEffectHolder);
                    } else {
                        playerEntity.addEffect(new MobEffectInstance((Holder)wrathOfTheHiveEffectHolder, BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
                    }
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (itemStack.is(BzTags.BEE_FEEDING_ITEMS)) {
            if (!level.isClientSide()) {
                int stage = (Integer)blockState.getValue((Property)STAGE);
                boolean successfulGrowth = false;
                if (itemStack.getItem() == BzItems.SUGAR_WATER_BOTTLE.get()) {
                    if (random.nextFloat() < 0.3f) {
                        successfulGrowth = true;
                    }
                } else {
                    successfulGrowth = true;
                }
                if (successfulGrowth && (stage == 3 || random.nextFloat() < 0.3f)) {
                    HoneycombBrood.applyProtection(playerEntity);
                }
                if (successfulGrowth) {
                    if (stage == 3) {
                        HoneycombBrood.spawnBroodMob(level, random, blockState, position, stage);
                    } else {
                        int newStage = stage + 1;
                        if (itemStack.is(BzTags.HONEY_BUCKETS) || itemStack.is(BzTags.ROYAL_JELLY_BUCKETS)) {
                            newStage = 3;
                            if (!level.isClientSide()) {
                                Direction facing = ((Direction)blockState.getValue((Property)FACING)).getOpposite();
                                Vec3 centerFacePos = new Vec3((double)position.getX() + Math.max(-0.2, facing.getStepX() == 0 ? 0.5 : (double)facing.getStepX() * 1.2), (double)position.getY() + Math.max(-0.2, facing.getStepY() == 0 ? 0.5 : (double)facing.getStepY() * 1.2), (double)position.getZ() + Math.max(-0.2, facing.getStepZ() == 0 ? 0.5 : (double)facing.getStepZ() * 1.2));
                                ((ServerLevel)level).sendParticles((ParticleOptions)ParticleTypes.HEART, centerFacePos.x(), centerFacePos.y(), centerFacePos.z(), 3, (double)random.nextFloat() * 0.5 - 0.25, (double)(random.nextFloat() * 0.2f + 0.2f), (double)random.nextFloat() * 0.5 - 0.25, (double)random.nextFloat() * 0.4 + (double)0.2f);
                            }
                            if (playerEntity instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
                                ((GenericTrigger)((Object)BzCriterias.HONEY_BUCKET_BROOD_TRIGGER.get())).trigger(serverPlayer);
                            }
                        }
                        level.setBlockAndUpdate(position, (BlockState)blockState.setValue((Property)STAGE, (Comparable)Integer.valueOf(newStage)));
                    }
                }
            }
            level.playSound(playerEntity, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            GeneralUtils.givePlayerItem(playerEntity, playerHand, ItemStack.EMPTY, true, true);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, position, playerEntity, playerHand, raytraceResult);
    }

    private static void applyProtection(Player playerEntity) {
        Level level = playerEntity.level();
        Registry mobEffects = level.registryAccess().registryOrThrow(Registries.MOB_EFFECT);
        playerEntity.addEffect(new MobEffectInstance((Holder)mobEffects.getHolder(BzEffects.PROTECTION_OF_THE_HIVE.getId()).get(), BzBeeAggressionConfigs.howLongProtectionOfTheHiveLasts, 0, false, false, true));
        ((ServerLevel)playerEntity.level()).sendParticles((ParticleOptions)((SimpleParticleType)BzParticles.SPARKLE_PARTICLE.get()), playerEntity.position().x(), playerEntity.getEyeY() - 0.25, playerEntity.position().z(), 20, playerEntity.getRandom().nextDouble() / 5.0 - 0.1, playerEntity.getRandom().nextDouble() / 5.0 - 0.1, playerEntity.getRandom().nextDouble() / 5.0 - 0.1, 0.1);
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            ((GenericTrigger)((Object)BzCriterias.GETTING_PROTECTION_TRIGGER.get())).trigger(serverPlayer);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos position, RandomSource random) {
        int stage;
        super.tick(state, level, position, random);
        if (!level.hasChunksAt(position, position)) {
            return;
        }
        List nearbyEntities = null;
        if (level.getDifficulty() == Difficulty.PEACEFUL) {
            Registry mobEffects = level.registryAccess().registryOrThrow(Registries.MOB_EFFECT);
            nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, new AABB(position).inflate(8.0), entity -> entity.hasEffect((Holder)mobEffects.getHolder(BzEffects.WRATH_OF_THE_HIVE.getId()).get()));
        }
        if ((stage = ((Integer)state.getValue((Property)STAGE)).intValue()) < 3) {
            if (nearbyEntities != null && !nearbyEntities.isEmpty() || (level.dimension().equals(BzDimension.BZ_WORLD_KEY) ? random.nextInt(10) == 0 : random.nextInt(22) == 0)) {
                level.setBlock(position, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)), 2);
            }
        } else if (BzGeneralConfigs.broodBlocksBeeSpawnCapacity != 0) {
            int livingEntitiesNearby;
            boolean playerCloseEnough = false;
            for (Player player : level.players()) {
                if (position.distManhattan((Vec3i)player.blockPosition()) >= 40) continue;
                playerCloseEnough = true;
            }
            if (playerCloseEnough && (livingEntitiesNearby = level.getEntitiesOfClass(LivingEntity.class, new AABB(Vec3.atLowerCornerOf((Vec3i)position.offset(-48, -48, -48)), Vec3.atLowerCornerOf((Vec3i)position.offset(48, 48, 48)))).size()) < BzGeneralConfigs.broodBlocksBeeSpawnCapacity) {
                HoneycombBrood.spawnBroodMob((Level)level, random, state, position, stage);
            }
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos position, BlockState state, Player playerEntity) {
        BlockState blockState;
        int stage;
        ServerLevel serverLevel;
        if (world instanceof ServerLevel && (serverLevel = (ServerLevel)world).getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS) && EnchantmentHelper.hasTag((ItemStack)playerEntity.getMainHandItem(), (TagKey)EnchantmentTags.PREVENTS_BEE_SPAWNS_WHEN_MINING) && (stage = ((Integer)(blockState = world.getBlockState(position)).getValue((Property)STAGE)).intValue()) == 3) {
            HoneycombBrood.spawnBroodMob(world, playerEntity.getRandom(), blockState, position, stage);
        }
        return super.playerWillDestroy(world, position, state, playerEntity);
    }

    private static void spawnBroodMob(Level world, RandomSource random, BlockState state, BlockPos position, int stage) {
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos().set((Vec3i)position);
        blockpos.move(((Direction)state.getValue((Property)FACING)).getOpposite());
        BlockState frontState = world.getBlockState((BlockPos)blockpos);
        if (stage == 3 && frontState.getFluidState().isEmpty() && !frontState.isCollisionShapeFullBlock((BlockGetter)world, position) && world.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING)) {
            Mob beeMob = (Mob)EntityType.BEE.create(world);
            beeMob.setBaby(true);
            HoneycombBrood.spawnMob(world, blockpos, beeMob, beeMob);
            if (random.nextFloat() < 0.1f) {
                Mob honeySlimeMob = (Mob)((EntityType)BzEntities.HONEY_SLIME.get()).create(world);
                honeySlimeMob.setBaby(true);
                HoneycombBrood.spawnMob(world, blockpos, beeMob, honeySlimeMob);
            }
            world.setBlockAndUpdate(position, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(0)));
        }
    }

    private static void spawnMob(Level world, BlockPos.MutableBlockPos blockpos, Mob beeMob, Mob entity) {
        if (entity == null || world.isClientSide()) {
            return;
        }
        entity.moveTo((double)blockpos.getX() + 0.5, (double)blockpos.getY() + 0.5, (double)blockpos.getZ() + 0.5, beeMob.getRandom().nextFloat() * 360.0f, 0.0f);
        entity.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(BlockPos.containing((Position)beeMob.position())), MobSpawnType.TRIGGERED, null);
        PlatformHooks.finalizeSpawn(entity, (ServerLevelAccessor)world, null, MobSpawnType.SPAWNER);
        world.addFreshEntity((Entity)entity);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        return (Integer)blockState.getValue((Property)STAGE) + 1;
    }

    public void animateTick(BlockState blockState, Level world, BlockPos position, RandomSource random) {
        for (int i = 0; i < random.nextInt(2); ++i) {
            this.spawnHoneyParticles(world, random, position, blockState);
        }
        int stage = (Integer)blockState.getValue((Property)STAGE);
        float soundVolume = 0.05f + (float)stage * 0.1f;
        if (random.nextInt(20) == 0) {
            world.playLocalSound((double)position.getX() + 0.5, (double)position.getY() + 0.5, (double)position.getZ() + 0.5, SoundEvents.BEE_LOOP, SoundSource.BLOCKS, soundVolume, 1.0f, true);
        }
    }

    private void spawnHoneyParticles(Level world, RandomSource random, BlockPos position, BlockState blockState) {
        VoxelShape currentBlockShape;
        double yEndHeight;
        if (blockState.getFluidState().isEmpty() && random.nextFloat() < 0.08f && (yEndHeight = (currentBlockShape = blockState.getCollisionShape((BlockGetter)world, position)).max(Direction.Axis.Y)) >= 1.0 && !blockState.is(BlockTags.IMPERMEABLE)) {
            double yStartHeight = currentBlockShape.min(Direction.Axis.Y);
            if (yStartHeight > 0.0) {
                this.addHoneyParticle(world, random, position, currentBlockShape, (double)position.getY() + yStartHeight - 0.05);
            } else {
                BlockPos belowBlockpos = position.below();
                BlockState belowBlockstate = world.getBlockState(belowBlockpos);
                VoxelShape belowBlockShape = belowBlockstate.getCollisionShape((BlockGetter)world, belowBlockpos);
                double yEndHeight2 = belowBlockShape.max(Direction.Axis.Y);
                if ((yEndHeight2 < 1.0 || !belowBlockstate.isSolidRender((BlockGetter)world, belowBlockpos)) && belowBlockstate.getFluidState().isEmpty()) {
                    this.addHoneyParticle(world, random, position, currentBlockShape, (double)position.getY() - 0.05);
                }
            }
        }
    }

    private void addHoneyParticle(Level world, RandomSource random, BlockPos blockPos, VoxelShape blockShape, double height) {
        this.addHoneyParticle(world, random, (double)blockPos.getX() + blockShape.min(Direction.Axis.X), (double)blockPos.getX() + blockShape.max(Direction.Axis.X), (double)blockPos.getZ() + blockShape.min(Direction.Axis.Z), (double)blockPos.getZ() + blockShape.max(Direction.Axis.Z), height);
    }

    private void addHoneyParticle(Level world, RandomSource random, double xMin, double xMax, double zMax, double zMin, double yHeight) {
        world.addParticle((ParticleOptions)ParticleTypes.DRIPPING_HONEY, Mth.lerp((double)random.nextDouble(), (double)xMin, (double)xMax), yHeight, Mth.lerp((double)random.nextDouble(), (double)zMax, (double)zMin), 0.0, 0.0, 0.0);
    }
}

