/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlock;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.bossbars.ServerEssenceEvent;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.living.CosmicCrystalEntity;
import com.telepathicgrunt.the_bumblezone.entities.living.CosmicCrystalState;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzStats;
import com.telepathicgrunt.the_bumblezone.packets.MusicPacketFromServer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;

public class EssenceBlockWhite
extends EssenceBlock {
    public static final MapCodec<EssenceBlockWhite> CODEC = Block.simpleCodec(EssenceBlockWhite::new);

    public EssenceBlockWhite() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.SNOW).strength(-1.0f, 3600000.8f).lightLevel(blockState -> 15).noLootTable().forceSolidOn().isValidSpawn((blockState, blockGetter, blockPos, entityType) -> false).isViewBlocking((blockState, blockGetter, blockPos) -> false).pushReaction(PushReaction.BLOCK));
    }

    public EssenceBlockWhite(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<? extends EssenceBlockWhite> codec() {
        return CODEC;
    }

    @Override
    public ResourceLocation getArenaNbt() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"essence/white_arena");
    }

    @Override
    public int getEventTimeFrame() {
        return 10000;
    }

    @Override
    public ServerEssenceEvent getServerEssenceEvent() {
        return (ServerEssenceEvent)new ServerEssenceEvent("essence.the_bumblezone.white_essence_event", BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.NOTCHED_6).setDarkenScreen(true);
    }

    @Override
    public ResourceLocation getEssenceItemReward() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"gameplay/rewards/white_arena_victory");
    }

    @Override
    public int getEssenceXpReward() {
        return 3000;
    }

    @Override
    public boolean hasMiningFatigue() {
        return true;
    }

    @Override
    public void awardPlayerWinStat(ServerPlayer serverPlayer) {
        serverPlayer.awardStat((ResourceLocation)BzStats.CONTINUITY_EVENT_DEFEATED_RL.get());
    }

    @Override
    public void performUniqueArenaTick(ServerLevel serverLevel, BlockPos blockPos, BlockState blockState, EssenceBlockEntity essenceBlockEntity) {
        if (essenceBlockEntity.getPlayerInArena().size() == 0) {
            return;
        }
        if (essenceBlockEntity.getEventTimer() > this.getEventTimeFrame() - 50) {
            return;
        }
        List<EssenceBlockEntity.EventEntities> eventEntitiesInArena = essenceBlockEntity.getEventEntitiesInArena();
        int totalCrystals = eventEntitiesInArena.size();
        int totalhealth = 0;
        float totalMaxHealth = 6 * BzGeneralConfigs.cosmicCrystalHealth;
        boolean respawnedACrystal = false;
        if (totalCrystals == 0 && essenceBlockEntity.getEventTimer() > this.getEventTimeFrame() - 100) {
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 0, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 60, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 120, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 180, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 240, 1.0f, eventEntitiesInArena);
            this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 300, 1.0f, eventEntitiesInArena);
            totalCrystals = 6;
        } else {
            ArrayList<CosmicCrystalEntity> crystals = new ArrayList<CosmicCrystalEntity>();
            boolean crystalsAreIdleLongEnough = true;
            for (int i = eventEntitiesInArena.size() - 1; i >= 0; --i) {
                Object nearbyCrystal2;
                UUID entityToCheck = eventEntitiesInArena.get(i).uuid();
                Object entity = serverLevel.getEntity(entityToCheck);
                if (entity == null) {
                    List nearbyCosmicCrystalEntities = serverLevel.getEntitiesOfClass(CosmicCrystalEntity.class, new AABB((double)((float)blockPos.getX() - (float)essenceBlockEntity.getArenaSize().getX() * 0.5f), (double)((float)blockPos.getY() - (float)essenceBlockEntity.getArenaSize().getY() * 0.5f), (double)((float)blockPos.getZ() - (float)essenceBlockEntity.getArenaSize().getZ() * 0.5f), (double)((float)blockPos.getX() + (float)essenceBlockEntity.getArenaSize().getX() * 0.5f), (double)((float)blockPos.getY() + (float)essenceBlockEntity.getArenaSize().getY() * 0.5f), (double)((float)blockPos.getZ() + (float)essenceBlockEntity.getArenaSize().getZ() * 0.5f)));
                    for (Object nearbyCrystal2 : nearbyCosmicCrystalEntities) {
                        if (!nearbyCrystal2.getUUID().equals(entityToCheck) || !nearbyCrystal2.getEssenceController().equals(essenceBlockEntity.getUUID())) continue;
                        entity = nearbyCrystal2;
                        break;
                    }
                }
                if (entity == null) {
                    eventEntitiesInArena.remove(i);
                    this.SpawnNewCrystal(serverLevel, blockPos, essenceBlockEntity, 60 * i, 1.0f, eventEntitiesInArena);
                    respawnedACrystal = true;
                }
                if (!(entity instanceof CosmicCrystalEntity)) continue;
                CosmicCrystalEntity cosmicCrystalEntity = (CosmicCrystalEntity)((Object)entity);
                nearbyCrystal2 = blockState.getBlock();
                if (nearbyCrystal2 instanceof EssenceBlock) {
                    EssenceBlock essenceBlock = (EssenceBlock)nearbyCrystal2;
                    if (essenceBlockEntity.getEventTimer() > essenceBlock.getEventTimeFrame() - 70) {
                        return;
                    }
                }
                totalhealth = (int)((float)totalhealth + cosmicCrystalEntity.getHealth());
                if (cosmicCrystalEntity.getCosmicCrystalState() != CosmicCrystalState.NORMAL || cosmicCrystalEntity.currentStateTimeTick < 50) {
                    crystalsAreIdleLongEnough = false;
                }
                crystals.add(cosmicCrystalEntity);
            }
            float healthPercent = (float)Math.round((float)totalhealth / totalMaxHealth * 10.0f) / 10.0f;
            int shieldThreshold = (int)Math.ceil((double)healthPercent / 0.166);
            int reductionInTicks = 600 * (6 - shieldThreshold);
            boolean shield = shieldThreshold > 0 && essenceBlockEntity.getEventTimer() + reductionInTicks > this.getEventTimeFrame();
            crystals.forEach(c -> c.setShield(shield));
            if (crystalsAreIdleLongEnough && !crystals.isEmpty()) {
                CosmicCrystalEntity crystalEntity;
                int i;
                CosmicCrystalState chosenAttack;
                while (((CosmicCrystalEntity)((Object)crystals.get((int)0))).pastStates.contains((Object)(chosenAttack = CosmicCrystalState.values()[serverLevel.getRandom().nextInt(CosmicCrystalState.values().length)])) || chosenAttack == CosmicCrystalState.NORMAL) {
                }
                float threshold = healthPercent > 0.75f ? 0.0f : (healthPercent > 0.5f ? 0.333f : (healthPercent > 0.25f ? 0.666f : 1.0f));
                CosmicCrystalState finalChosenAttack = chosenAttack;
                crystals.forEach(c -> c.setCosmicCrystalState(finalChosenAttack));
                boolean missingCrystal = respawnedACrystal;
                for (i = 0; i < crystals.size(); ++i) {
                    float difficultyBuff;
                    float newDifficulty;
                    crystalEntity = (CosmicCrystalEntity)((Object)crystals.get(i));
                    int orbitOffset = crystalEntity.getOrbitOffsetDegrees();
                    if (orbitOffset % (360 / crystals.size()) != 0) {
                        missingCrystal = true;
                    }
                    if ((newDifficulty = (1.0f + 0.025f * (float)(6 - totalCrystals)) * (difficultyBuff = (float)(1.0 + Math.pow(threshold, 2.0) * (double)0.35f))) == crystalEntity.getDifficultyBoost()) continue;
                    crystalEntity.setDifficultyBoost(newDifficulty);
                }
                if (missingCrystal) {
                    for (i = 0; i < crystals.size(); ++i) {
                        crystalEntity = (CosmicCrystalEntity)((Object)crystals.get(i));
                        crystalEntity.setOrbitOffsetDegrees(i * (360 / crystals.size()));
                        crystalEntity.currentTickCount = 0;
                    }
                }
            }
        }
        if (totalCrystals == 0) {
            EssenceBlockEntity.EndEvent(serverLevel, blockPos, blockState, essenceBlockEntity, true);
        }
        essenceBlockEntity.getEventBar().setProgress((float)totalhealth / totalMaxHealth);
    }

    private Entity SpawnNewCrystal(ServerLevel serverLevel, BlockPos blockPos, EssenceBlockEntity essenceBlockEntity, int orbitOffset, float difficultyBoost, List<EssenceBlockEntity.EventEntities> eventEntitiesInArena) {
        CosmicCrystalEntity entity = (CosmicCrystalEntity)((EntityType)BzEntities.COSMIC_CRYSTAL_ENTITY.get()).spawn(serverLevel, blockPos, MobSpawnType.TRIGGERED);
        if (entity != null) {
            entity.addTag("the_bumblezone.white_essence_arena");
            entity.setEssenceControllerDimension((ResourceKey<Level>)serverLevel.dimension());
            entity.setEssenceController(essenceBlockEntity.getUUID());
            entity.setEssenceControllerBlockPos(essenceBlockEntity.getBlockPos());
            entity.setOrbitOffsetDegrees(orbitOffset);
            entity.setDifficultyBoost(difficultyBoost);
            eventEntitiesInArena.add(new EssenceBlockEntity.EventEntities(entity.getUUID()));
        }
        return entity;
    }

    public void crystalKilled(CosmicCrystalEntity cosmicCrystalEntity, EssenceBlockEntity essenceBlockEntity) {
        essenceBlockEntity.getEventEntitiesInArena().removeIf(e -> e.uuid().equals(cosmicCrystalEntity.getUUID()));
    }

    @Override
    public void onPlayerEnter(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.CONTINUITY_EVENT.get()).getLocation(), true);
        super.onPlayerEnter(serverLevel, serverPlayer, essenceBlockEntity);
    }

    @Override
    public void onPlayerLeave(ServerLevel serverLevel, ServerPlayer serverPlayer, EssenceBlockEntity essenceBlockEntity) {
        MusicPacketFromServer.sendToClient((Player)serverPlayer, ((SoundEvent)BzSounds.CONTINUITY_EVENT.get()).getLocation(), false);
        super.onPlayerLeave(serverLevel, serverPlayer, essenceBlockEntity);
    }
}

