/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import org.jetbrains.annotations.NotNull;

public class IconWidget
extends Widget {
    private final ResourceLocation BG = ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/tf_bg.png");
    private TextureAtlasSprite effectSprite;
    private final Minecraft minecraft = Minecraft.getInstance();

    public IconWidget(int x, int y, int width, int height, String effectName) {
        super(x, y, width, height, "");
        this.setEffectAtlasSprite(effectName);
    }

    public void setEffectAtlasSprite(String effectName) {
        MobEffect effect = (MobEffect)BuiltInRegistries.MOB_EFFECT.get(ResourceLocation.parse((String)effectName));
        if (effect == null) {
            this.effectSprite = null;
            return;
        }
        this.effectSprite = this.minecraft.getMobEffectTextures().get(BuiltInRegistries.MOB_EFFECT.wrapAsHolder((Object)effect));
    }

    @Override
    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float pt) {
        super.render(gui, mouseX, mouseY, pt);
        gui.pose().pushPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        this.renderBackground(gui);
        this.renderIcon(gui);
        RenderSystem.disableBlend();
        gui.pose().popPose();
    }

    private void renderIcon(GuiGraphics gui) {
        if (this.effectSprite == null) {
            return;
        }
        gui.blit(this.x + 2, this.y + 2, 0, 16, 16, this.effectSprite);
    }

    private void renderBackground(GuiGraphics gui) {
        gui.blit(this.BG, this.x, this.y, 2, 2, 16.0f, 0.0f, 2, 2, 32, 32);
        gui.blit(this.BG, this.x + this.width - 2, this.y, 2, 2, 30.0f, 0.0f, 2, 2, 32, 32);
        gui.blit(this.BG, this.x, this.y + this.height - 2, 2, 2, 16.0f, 14.0f, 2, 2, 32, 32);
        gui.blit(this.BG, this.x + this.width - 2, this.y + this.height - 2, 2, 2, 30.0f, 14.0f, 2, 2, 32, 32);
        gui.blit(this.BG, this.x + 2, this.y, this.width - 4, 2, 18.0f, 0.0f, 12, 2, 32, 32);
        gui.blit(this.BG, this.x + this.width - 2, this.y + 2, 2, this.height - 4, 30.0f, 2.0f, 2, 12, 32, 32);
        gui.blit(this.BG, this.x + 2, this.y + this.height - 2, this.width - 4, 2, 18.0f, 14.0f, 12, 2, 32, 32);
        gui.blit(this.BG, this.x, this.y + 2, 2, this.height - 4, 16.0f, 2.0f, 2, 12, 32, 32);
        gui.blit(this.BG, this.x + 2, this.y + 2, this.width - 4, this.height - 4, 18.0f, 2.0f, 12, 12, 32, 32);
    }
}

