/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.HudRenderer;
import dlovin.inventoryhud.utils.EachItem;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;

public class ArmorRenderer
extends HudRenderer {
    protected static Predicate<ItemStack> AMMO_TYPES = i -> i.getItem() instanceof ArrowItem;
    public boolean showMain;
    public boolean showOff;
    public boolean showArmor;
    public boolean showEmpty;
    public boolean showInv;
    public boolean showArrows;
    public boolean armBars;
    public boolean showCount;
    public boolean withDebug;
    public boolean showArrowsWithoutWeapon;
    public int armX;
    public int armY;
    public int armAbove;
    public float armScale;
    public WidgetAligns ArmAligns;
    public InvConfig.ArmorView armView;
    public EachItem[] items = new EachItem[8];
    Minecraft mc;
    ItemRenderer itemRenderer;
    ResourceLocation[] armorRL = new ResourceLocation[]{ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_armor_slot_helmet.png"), ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_armor_slot_chestplate.png"), ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_armor_slot_leggings.png"), ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_armor_slot_boots.png"), ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_armor_slot_shield.png"), ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/empty_main_hand_slot.png"), ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/inventory.png"), ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/item/arrows.png")};

    public ArmorRenderer(Minecraft mc) {
        this.mc = mc;
        this.itemRenderer = mc.getItemRenderer();
    }

    protected String getText(ItemStack item, int damage) {
        return switch (this.armView) {
            default -> throw new MatchException(null, null);
            case InvConfig.ArmorView.PERCENTAGE -> this.getDamageText(String.valueOf(damage), damage) + String.valueOf(ChatFormatting.WHITE) + "%";
            case InvConfig.ArmorView.DAMAGE -> this.getDamageText(String.valueOf(item.getDamageValue()), damage);
            case InvConfig.ArmorView.DAMAGE_LEFT -> this.getDamageText(String.valueOf(item.getMaxDamage() - item.getDamageValue()), damage);
            case InvConfig.ArmorView.OFF -> null;
        };
    }

    private String getDamageText(String p, int d) {
        Object result = p;
        if (d == 100) {
            result = String.valueOf(ChatFormatting.GREEN) + (String)result;
        } else if (d < 1) {
            result = String.valueOf(ChatFormatting.DARK_RED) + (String)result;
        } else if (d <= 10) {
            result = String.valueOf(ChatFormatting.RED) + (String)result;
        } else if (d <= 25) {
            result = String.valueOf(ChatFormatting.GOLD) + (String)result;
        } else if (d <= 50) {
            result = String.valueOf(ChatFormatting.YELLOW) + (String)result;
        }
        return result;
    }

    protected boolean showArrows() {
        return this.showArrows && (this.withProjectileWeapon(this.mc.player.getMainHandItem(), this.mc.player.getOffhandItem()) || this.showArrowsWithoutWeapon);
    }

    private boolean withProjectileWeapon(ItemStack mainHand, ItemStack offHand) {
        return mainHand.getItem() instanceof ProjectileWeaponItem || offHand.getItem() instanceof ProjectileWeaponItem;
    }

    Predicate<ItemStack> getAllProj(ItemStack mainHand, ItemStack offHand) {
        Item item = mainHand.getItem();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem item2 = (ProjectileWeaponItem)item;
            return item2.getSupportedHeldProjectiles().and(i -> offHand == i).or(item2.getAllSupportedProjectiles());
        }
        item = offHand.getItem();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem item3 = (ProjectileWeaponItem)item;
            return item3.getSupportedHeldProjectiles().and(i -> mainHand == i).or(item3.getAllSupportedProjectiles());
        }
        return AMMO_TYPES;
    }

    protected int[] getFreeAndAmmo() {
        int[] result = new int[]{0, 0};
        Predicate<ItemStack> ammoTypes = this.getAllProj(this.mc.player.getMainHandItem(), this.mc.player.getOffhandItem());
        for (ItemStack slot : this.mc.player.getInventory().items) {
            if (slot.isEmpty()) {
                result[0] = result[0] + 1;
            }
            if (!this.isAmmo(slot, ammoTypes)) continue;
            result[1] = result[1] + slot.getCount();
        }
        for (ItemStack slot : this.mc.player.getInventory().offhand) {
            if (!this.isAmmo(slot, ammoTypes)) continue;
            result[1] = result[1] + slot.getCount();
        }
        return result;
    }

    boolean isAmmo(ItemStack stack, Predicate<ItemStack> ammoTypes) {
        return !stack.isEmpty() && ammoTypes.test(stack);
    }

    int getItemCount(ItemStack item) {
        int result = 0;
        for (ItemStack slot : this.mc.player.getInventory().items) {
            if (!ItemStack.isSameItem((ItemStack)slot, (ItemStack)item)) continue;
            result += slot.getCount();
        }
        for (ItemStack slot : this.mc.player.getInventory().offhand) {
            if (!ItemStack.isSameItem((ItemStack)slot, (ItemStack)item)) continue;
            result += slot.getCount();
        }
        return result;
    }

    boolean getRight(int x, WidgetAligns.HAlign hal) {
        return switch (hal) {
            default -> throw new MatchException(null, null);
            case WidgetAligns.HAlign.LEFT -> false;
            case WidgetAligns.HAlign.MIDDLE -> {
                if (x > 0) {
                    yield true;
                }
                yield false;
            }
            case WidgetAligns.HAlign.RIGHT -> true;
        };
    }

    void renderElementInBlock(GuiGraphics gui, int offSetX, int offSetY, boolean right, @Nullable ResourceLocation res, @Nullable ItemStack item, @Nullable String text, boolean overlay, int seed) {
        if (res != null) {
            gui.blit(res, offSetX, offSetY, 16.0f, 16.0f, 16, 16, 16, 16);
        } else {
            gui.pose().pushPose();
            gui.pose().translate((double)offSetX, (double)offSetY, -256.0);
            gui.renderItem((LivingEntity)this.mc.player, item, 0, 0, seed);
            if (overlay) {
                gui.renderItemDecorations(this.mc.font, item, 0, 0);
            }
            gui.pose().popPose();
        }
        if (text == null) {
            return;
        }
        gui.drawString(this.mc.font, text, right ? offSetX + 17 : offSetX - 1 - this.mc.font.width(text), offSetY + 4, 0xFFFFFF);
    }

    void renderElement(GuiGraphics gui, boolean right, @Nullable ResourceLocation res, @Nullable ItemStack item, @Nullable String text, boolean overlay, int seed) {
        if (res != null) {
            gui.blit(res, 0, 0, 16.0f, 16.0f, 16, 16, 16, 16);
        } else {
            gui.pose().pushPose();
            gui.renderItem((LivingEntity)this.mc.player, item, 0, 0, seed);
            if (overlay) {
                gui.renderItemDecorations(this.mc.font, item, 0, 0);
            }
            gui.pose().popPose();
        }
        if (text == null) {
            return;
        }
        gui.drawString(this.mc.font, text, right ? 17 : -1 - this.mc.font.width(text), 4, 0xFFFFFF);
    }

    public void render(GuiGraphics gui, int width, int height) {
    }

    protected void preRender(GuiGraphics gui, int x, int y) {
        gui.pose().pushPose();
        gui.pose().translate((double)x, (double)y, -256.0);
    }

    protected void postRender(GuiGraphics gui) {
        gui.pose().popPose();
    }
}

