/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketGrabbedEntitiesToClient(BlockPos pos, Set<Integer> grabbedEntities) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsbuilder", (String)"grabbed_entities_to_client");
    public static final CustomPacketPayload.Type<PacketGrabbedEntitiesToClient> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, PacketGrabbedEntitiesToClient> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketGrabbedEntitiesToClient::pos, (StreamCodec)ByteBufCodecs.INT.apply(ByteBufCodecs.list()), s -> new ArrayList<Integer>(s.grabbedEntities), (pos, list) -> new PacketGrabbedEntitiesToClient((BlockPos)pos, (Set<Integer>)new HashSet<Integer>((Collection<Integer>)list)));

    public PacketGrabbedEntitiesToClient(BlockPos pos, Set<Integer> grabbedEntities) {
        this.pos = pos;
        this.grabbedEntities = new HashSet<Integer>(grabbedEntities);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static PacketGrabbedEntitiesToClient create(BlockPos worldPosition, Set<Integer> integers) {
        return new PacketGrabbedEntitiesToClient(worldPosition, integers);
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity patt0$temp = SafeClientTools.getClientWorld().getBlockEntity(this.pos);
            if (patt0$temp instanceof MoverTileEntity) {
                MoverTileEntity mover = (MoverTileEntity)patt0$temp;
                mover.getLogic().setGrabbedEntitiesClient(this.grabbedEntities);
            }
        });
    }
}

