/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.soulplied_energistics.applied.strategies;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import com.buuz135.industrialforegoingsouls.capabilities.ISoulHandler;
import com.buuz135.industrialforegoingsouls.capabilities.SoulCapabilities;
import com.buuz135.soulplied_energistics.applied.SoulKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.Nullable;

public class SoulExternalStorageStrategy
implements ExternalStorageStrategy {
    private ServerLevel level;
    private BlockPos fromPos;
    private Direction fromSide;

    public SoulExternalStorageStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.level = level;
        this.fromPos = fromPos;
        this.fromSide = fromSide;
    }

    @Nullable
    public MEStorage createWrapper(boolean b, Runnable runnable) {
        ISoulHandler cap = (ISoulHandler)this.level.getCapability(SoulCapabilities.BLOCK, this.fromPos, (Object)this.fromSide);
        if (cap != null) {
            return new SoulLaserDrillMEStorage(cap);
        }
        return null;
    }

    private record SoulLaserDrillMEStorage(ISoulHandler baseBlock) implements MEStorage
    {
        public boolean isPreferredStorageFor(AEKey what, IActionSource source) {
            return super.isPreferredStorageFor(what, source);
        }

        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            return this.baseBlock.fill((int)amount, mode.isSimulate() ? ISoulHandler.Action.SIMULATE : ISoulHandler.Action.EXECUTE);
        }

        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            return this.baseBlock.drain((int)amount, mode.isSimulate() ? ISoulHandler.Action.SIMULATE : ISoulHandler.Action.EXECUTE);
        }

        public void getAvailableStacks(KeyCounter out) {
            for (int i = 0; i < this.baseBlock.getSoulTanks(); ++i) {
                out.add((AEKey)SoulKey.INSTANCE, (long)this.baseBlock.getSoulInTank(i));
            }
        }

        public Component getDescription() {
            return Component.translatable((String)"soulstorage.description");
        }

        public KeyCounter getAvailableStacks() {
            return super.getAvailableStacks();
        }
    }
}

