/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterendisland.mixin;

import com.yungnickyoung.minecraft.betterendisland.world.IEndSpike;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.feature.SpikeFeature;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpikeFeature.EndSpike.class})
public abstract class EndSpikeMixin
implements IEndSpike {
    @Shadow
    @Final
    @Mutable
    private AABB topBoundingBox;
    @Shadow
    @Final
    private int height;
    @Unique
    private int crystalHeight = 0;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void betterendisland_adjustSpikeBoundingBox(int centerX, int centerZ, int radius, int height, boolean guarded, CallbackInfo ci) {
        this.topBoundingBox = new AABB((double)(centerX - 9), (double)DimensionType.MIN_Y, (double)(centerZ - 9), (double)(centerX + 9), (double)DimensionType.MAX_Y, (double)(centerZ + 9));
    }

    @Inject(method={"getHeight"}, at={@At(value="HEAD")}, cancellable=true)
    private void betterendisland_getSpikeHeight(CallbackInfoReturnable<Integer> cir) {
        cir.setReturnValue((Object)this.height);
    }

    @Override
    @Unique
    public int getCrystalYOffset() {
        return this.crystalHeight;
    }

    @Override
    @Unique
    public void setCrystalYOffsetFromPillarHeight(int pillarHeight) {
        this.crystalHeight = switch (pillarHeight) {
            case 6, 7, 8 -> 32;
            case 4, 5 -> 27;
            case 3 -> 26;
            case 1, 2 -> 22;
            default -> 38;
        };
    }
}

