/*
 * Decompiled with CFR 0.152.
 */
package tamaized.ae2jeiintegration.integration.modules.jei.categories;

import appeng.api.config.CondenserOutput;
import appeng.api.implementations.items.IStorageComponent;
import appeng.client.gui.Icon;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.core.localization.ButtonToolTips;
import appeng.items.materials.StorageComponentItem;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import tamaized.ae2jeiintegration.integration.modules.jei.categories.AbstractCategory;

public class CondenserCategory
extends AbstractCategory<CondenserOutput> {
    private static final String TITLE_TRANSLATION_KEY = "block.ae2.condenser";
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"textures/guis/condenser.png");
    public static final RecipeType<CondenserOutput> RECIPE_TYPE = RecipeType.create((String)"ae2", (String)"condenser", CondenserOutput.class);
    private final IDrawableAnimated progress;
    private final Map<CondenserOutput, Icon> buttonIcons;
    private final Map<CondenserOutput, ResourceLocation> resourceLocations;

    public CondenserCategory(IGuiHelper guiHelper) {
        super(guiHelper, (ItemLike)AEBlocks.CONDENSER, (Component)Component.translatable((String)TITLE_TRANSLATION_KEY), (IDrawable)guiHelper.createDrawable(TEXTURE, 48, 25, 96, 48));
        this.progress = guiHelper.drawableBuilder(TEXTURE, 176, 0, 6, 18).addPadding(0, 0, 72, 0).buildAnimated(40, IDrawableAnimated.StartDirection.BOTTOM, false);
        this.buttonIcons = new EnumMap<CondenserOutput, Icon>(CondenserOutput.class);
        this.buttonIcons.put(CondenserOutput.MATTER_BALLS, Icon.CONDENSER_OUTPUT_MATTER_BALL);
        this.buttonIcons.put(CondenserOutput.SINGULARITY, Icon.CONDENSER_OUTPUT_SINGULARITY);
        this.resourceLocations = new EnumMap<CondenserOutput, ResourceLocation>(CondenserOutput.class);
        this.resourceLocations.put(CondenserOutput.TRASH, ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"trash"));
        this.resourceLocations.put(CondenserOutput.MATTER_BALLS, ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"matter_balls"));
        this.resourceLocations.put(CondenserOutput.SINGULARITY, ResourceLocation.fromNamespaceAndPath((String)"ae2", (String)"singularity"));
    }

    private static ItemStack getOutput(CondenserOutput recipe) {
        return switch (recipe) {
            case CondenserOutput.MATTER_BALLS -> AEItems.MATTER_BALL.stack();
            case CondenserOutput.SINGULARITY -> AEItems.SINGULARITY.stack();
            default -> ItemStack.EMPTY;
        };
    }

    public RecipeType<CondenserOutput> getRecipeType() {
        return RECIPE_TYPE;
    }

    public void draw(CondenserOutput recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.progress.draw(guiGraphics);
        Icon.BACKGROUND_TRASH.getBlitter().dest(3, 27).blit(guiGraphics);
        Icon.TOOLBAR_BUTTON_BACKGROUND.getBlitter().dest(80, 26).blit(guiGraphics);
        Icon buttonIcon = this.buttonIcons.get(recipe);
        if (buttonIcon != null) {
            buttonIcon.getBlitter().dest(81, 27).blit(guiGraphics);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CondenserOutput recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 57, 27).addItemStack(CondenserCategory.getOutput(recipe));
        builder.addSlot(RecipeIngredientRole.CATALYST, 53, 1).addItemStacks(CondenserCategory.getViableStorageComponents(recipe));
    }

    private static List<ItemStack> getViableStorageComponents(CondenserOutput condenserOutput) {
        ArrayList<ItemStack> viableComponents = new ArrayList<ItemStack>();
        CondenserCategory.addViableComponent(condenserOutput, viableComponents, (ItemDefinition<StorageComponentItem>)AEItems.CELL_COMPONENT_1K);
        CondenserCategory.addViableComponent(condenserOutput, viableComponents, (ItemDefinition<StorageComponentItem>)AEItems.CELL_COMPONENT_4K);
        CondenserCategory.addViableComponent(condenserOutput, viableComponents, (ItemDefinition<StorageComponentItem>)AEItems.CELL_COMPONENT_16K);
        CondenserCategory.addViableComponent(condenserOutput, viableComponents, (ItemDefinition<StorageComponentItem>)AEItems.CELL_COMPONENT_64K);
        CondenserCategory.addViableComponent(condenserOutput, viableComponents, (ItemDefinition<StorageComponentItem>)AEItems.CELL_COMPONENT_256K);
        return viableComponents;
    }

    private static void addViableComponent(CondenserOutput condenserOutput, List<ItemStack> viableComponents, ItemDefinition<StorageComponentItem> storageComponent) {
        ItemStack itemStack;
        IStorageComponent comp = (IStorageComponent)storageComponent.get();
        int storage = comp.getBytes(itemStack = storageComponent.stack()) * 8;
        if (storage >= condenserOutput.requiredPower) {
            viableComponents.add(itemStack);
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, CondenserOutput recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 80.0 && mouseX < 96.0 && mouseY >= 26.0 && mouseY < 42.0) {
            String[] tooltipLines;
            String key;
            switch (recipe) {
                case MATTER_BALLS: {
                    key = ButtonToolTips.MatterBalls.getTranslationKey();
                    break;
                }
                case SINGULARITY: {
                    key = ButtonToolTips.Singularity.getTranslationKey();
                    break;
                }
                default: {
                    return;
                }
            }
            String tooltipString = Component.translatable((String)key, (Object[])new Object[]{recipe.requiredPower}).getString();
            for (String line : tooltipLines = tooltipString.split("\n")) {
                tooltip.add((FormattedText)Component.literal((String)line));
            }
        }
    }

    @Nullable
    public ResourceLocation getRegistryName(CondenserOutput recipe) {
        return this.resourceLocations.get(recipe);
    }
}

