/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import appeng.api.stacks.AEKey;
import appeng.core.network.ClientboundPacket;
import appeng.core.network.CustomAppEngPayload;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.pedroksl.advanced_ae.client.gui.AdvPatternEncoderScreen;

public record AdvPatternEncoderPacket(LinkedHashMap<AEKey, Direction> dirMap) implements ClientboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, AdvPatternEncoderPacket> STREAM_CODEC = StreamCodec.ofMember(AdvPatternEncoderPacket::write, AdvPatternEncoderPacket::decode);
    public static final CustomPacketPayload.Type<AdvPatternEncoderPacket> TYPE = CustomAppEngPayload.createType((String)"pattern_encoder_update");

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.dirMap.size());
        for (Map.Entry<AEKey, Direction> entry : this.dirMap.entrySet()) {
            AEKey.writeKey((RegistryFriendlyByteBuf)buf, (AEKey)entry.getKey());
            Direction dir = entry.getValue();
            if (dir == null) {
                buf.writeBoolean(false);
                continue;
            }
            buf.writeBoolean(true);
            buf.writeEnum((Enum)entry.getValue());
        }
    }

    public static AdvPatternEncoderPacket decode(RegistryFriendlyByteBuf buf) {
        LinkedHashMap<AEKey, Direction> dirMap = new LinkedHashMap<AEKey, Direction>();
        int size = buf.readInt();
        for (int x = 0; x < size; ++x) {
            AEKey key = AEKey.readKey((RegistryFriendlyByteBuf)buf);
            Direction dir = buf.readBoolean() ? (Direction)buf.readEnum(Direction.class) : null;
            dirMap.put(key, dir);
        }
        return new AdvPatternEncoderPacket(dirMap);
    }

    public void handleOnClient(Player player) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof AdvPatternEncoderScreen) {
            AdvPatternEncoderScreen encoderGui = (AdvPatternEncoderScreen)screen;
            encoderGui.update(this.dirMap);
        }
    }
}

