/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import appeng.api.config.Setting;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.network.CustomAppEngPayload;
import appeng.core.network.ServerboundPacket;
import appeng.menu.AEBaseMenu;
import appeng.util.EnumCycler;
import java.util.Set;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.pedroksl.advanced_ae.api.AAESettings;

public record AAEConfigButtonPacket(Setting<?> option, boolean rotationDirection) implements ServerboundPacket
{
    public static final StreamCodec<RegistryFriendlyByteBuf, AAEConfigButtonPacket> STREAM_CODEC = StreamCodec.ofMember(AAEConfigButtonPacket::write, AAEConfigButtonPacket::decode);
    public static final CustomPacketPayload.Type<AAEConfigButtonPacket> TYPE = CustomAppEngPayload.createType((String)"aae_config_button");

    public CustomPacketPayload.Type<AAEConfigButtonPacket> type() {
        return TYPE;
    }

    public static AAEConfigButtonPacket decode(RegistryFriendlyByteBuf stream) {
        Setting option = AAESettings.getOrThrow((String)stream.readUtf());
        boolean rotationDirection = stream.readBoolean();
        return new AAEConfigButtonPacket(option, rotationDirection);
    }

    public void write(RegistryFriendlyByteBuf data) {
        data.writeUtf(this.option.getName());
        data.writeBoolean(this.rotationDirection);
    }

    public void handleOnServer(ServerPlayer player) {
        AEBaseMenu baseMenu;
        Object object;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof AEBaseMenu && (object = (baseMenu = (AEBaseMenu)abstractContainerMenu).getTarget()) instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)object;
            IConfigManager cm = configurableObject.getConfigManager();
            if (cm.hasSetting(this.option)) {
                this.cycleSetting(cm, this.option);
            } else {
                AELog.info((String)"Ignoring unsupported setting %s sent by client on %s", (Object[])new Object[]{this.option, baseMenu.getTarget()});
            }
        }
    }

    private <T extends Enum<T>> void cycleSetting(IConfigManager cm, Setting<T> setting) {
        Enum currentValue = cm.getSetting(setting);
        Enum nextValue = EnumCycler.rotateEnum((Enum)currentValue, (boolean)this.rotationDirection, (Set)setting.getValues());
        cm.putSetting(setting, nextValue);
    }
}

