/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.GenericStack;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.IConfigManager;
import appeng.core.network.ClientboundPacket;
import appeng.helpers.externalstorage.GenericStackInv;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.UpgradeableMenu;
import appeng.menu.interfaces.IProgressProvider;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.slot.AppEngSlot;
import appeng.menu.slot.OutputSlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.entities.ReactionChamberEntity;
import net.pedroksl.advanced_ae.recipes.ReactionChamberRecipes;
import net.pedroksl.ae2addonlib.api.IFluidTankHandler;
import net.pedroksl.ae2addonlib.gui.OutputDirectionMenu;
import net.pedroksl.ae2addonlib.network.clientPacket.FluidTankClientAudioPacket;
import net.pedroksl.ae2addonlib.network.clientPacket.FluidTankStackUpdatePacket;

public class ReactionChamberMenu
extends UpgradeableMenu<ReactionChamberEntity>
implements IProgressProvider,
IFluidTankHandler {
    @GuiSync(value=2)
    public int maxProcessingTime = -1;
    @GuiSync(value=3)
    public int processingTime = -1;
    @GuiSync(value=7)
    public YesNo autoExport = YesNo.NO;
    @GuiSync(value=8)
    public boolean showWarning = false;
    public final int INPUT_FLUID_SIZE = 16;
    public final int OUTPUT_FLUID_SIZE = 16;
    private static final String FLUSH_FLUID = "flushFluid";
    private static final String FLUSH_FLUID_OUT = "flushFluidOut";
    private static final String CONFIGURE_OUTPUT = "configureOutput";
    private final List<Slot> inputs = new ArrayList<Slot>(9);

    public ReactionChamberMenu(int id, Inventory ip, ReactionChamberEntity host) {
        super(AAEMenus.REACTION_CHAMBER.get(), id, ip, (IUpgradeableObject)host);
        InternalInventory inputs = host.getInput();
        for (int x = 0; x < inputs.size(); ++x) {
            this.inputs.add(x, this.addSlot((Slot)new AppEngSlot(inputs, x), SlotSemantics.MACHINE_INPUT));
        }
        OutputSlot output = new OutputSlot(host.getOutput(), 0, null);
        this.addSlot((Slot)output, SlotSemantics.MACHINE_OUTPUT);
        this.registerClientAction(FLUSH_FLUID, this::clearFluid);
        this.registerClientAction(FLUSH_FLUID_OUT, this::clearFluidOut);
        this.registerClientAction(CONFIGURE_OUTPUT, this::configureOutput);
    }

    protected void loadSettingsFromHost(IConfigManager cm) {
        this.autoExport = (YesNo)((ReactionChamberEntity)this.getHost()).getConfigManager().getSetting(Settings.AUTO_EXPORT);
    }

    protected void standardDetectAndSendChanges() {
        if (this.isServerSide()) {
            this.maxProcessingTime = ((ReactionChamberEntity)this.getHost()).getMaxProcessingTime();
            this.processingTime = ((ReactionChamberEntity)this.getHost()).getProcessingTime();
            this.showWarning = ((ReactionChamberEntity)this.getHost()).showWarning();
            GenericStack genInput = ((ReactionChamberEntity)this.getHost()).getTank().getStack(1);
            FluidStack inputFluid = FluidStack.EMPTY;
            if (genInput != null && genInput.what() != null) {
                inputFluid = ((AEFluidKey)genInput.what()).toStack((int)genInput.amount());
            }
            this.sendPacketToClient((ClientboundPacket)new FluidTankStackUpdatePacket(1, inputFluid));
            GenericStack genOutput = ((ReactionChamberEntity)this.getHost()).getTank().getStack(0);
            FluidStack outputFluid = FluidStack.EMPTY;
            if (genOutput != null && genOutput.what() != null) {
                outputFluid = ((AEFluidKey)genOutput.what()).toStack((int)genOutput.amount());
            }
            this.sendPacketToClient((ClientboundPacket)new FluidTankStackUpdatePacket(0, outputFluid));
        }
        super.standardDetectAndSendChanges();
    }

    public boolean isValidForSlot(Slot s, ItemStack is) {
        if (this.inputs.contains(s)) {
            return ReactionChamberRecipes.isValidIngredient(is, ((ReactionChamberEntity)this.getHost()).getLevel());
        }
        return true;
    }

    public int getCurrentProgress() {
        return this.processingTime;
    }

    public int getMaxProgress() {
        return this.maxProcessingTime;
    }

    public YesNo getAutoExport() {
        return this.autoExport;
    }

    public boolean getShowWarning() {
        return this.showWarning;
    }

    public void clearFluid() {
        if (this.isClientSide()) {
            this.sendClientAction(FLUSH_FLUID);
            return;
        }
        ((ReactionChamberEntity)this.getHost()).clearFluid();
    }

    public void clearFluidOut() {
        if (this.isClientSide()) {
            this.sendClientAction(FLUSH_FLUID_OUT);
            return;
        }
        ((ReactionChamberEntity)this.getHost()).clearFluidOut();
    }

    public void configureOutput() {
        if (this.isClientSide()) {
            this.sendClientAction(CONFIGURE_OUTPUT);
            return;
        }
        MenuHostLocator locator = this.getLocator();
        if (locator != null && this.isServerSide()) {
            OutputDirectionMenu.open((ServerPlayer)((ServerPlayer)this.getPlayer()), (MenuHostLocator)this.getLocator(), ((ReactionChamberEntity)this.getHost()).getAllowedOutputs());
        }
    }

    public ItemStack getCarriedItem() {
        return this.getCarried();
    }

    public void setCarriedItem(ItemStack stack) {
        this.setCarried(stack);
    }

    public GenericStackInv getTank() {
        return ((ReactionChamberEntity)this.getHost()).getTank();
    }

    public boolean canExtractFromTank(int index) {
        return true;
    }

    public boolean canInsertInto(int index) {
        return index == 1;
    }

    public void playAudioCues(FluidTankClientAudioPacket p) {
        this.sendPacketToClient((ClientboundPacket)p);
    }
}

