/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.pedroksl.advanced_ae.datagen.AAELanguageProvider;
import net.pedroksl.advanced_ae.datagen.AAELootTableProvider;
import net.pedroksl.advanced_ae.datagen.AAEModelProvider;
import net.pedroksl.advanced_ae.datagen.AAERecipeProvider;
import net.pedroksl.advanced_ae.datagen.AAETagProvider;

@EventBusSubscriber(modid="advanced_ae", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class AAEDataGen {
    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput out = gen.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookup = event.getLookupProvider();
        AAELanguageProvider languageProvider = new AAELanguageProvider(out);
        gen.addProvider(event.includeClient(), (DataProvider)new AAEModelProvider(out, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new AAERecipeProvider(out, lookup));
        gen.addProvider(event.includeServer(), (DataProvider)new AAELootTableProvider(out, lookup));
        AAETagProvider.AAEBlockTagProvider blockTags = new AAETagProvider.AAEBlockTagProvider(out, lookup, fileHelper);
        AAETagProvider.AAEItemTagProvider itemTags = new AAETagProvider.AAEItemTagProvider(out, lookup, blockTags.contentsGetter(), fileHelper);
        AAETagProvider.AAEDataComponentTypeTagProvider componentTags = new AAETagProvider.AAEDataComponentTypeTagProvider(out, lookup, fileHelper, languageProvider);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)itemTags);
        gen.addProvider(event.includeClient(), (DataProvider)languageProvider);
    }
}

