/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.parts;

import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.FuzzyMode;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.util.IConfigManagerBuilder;
import appeng.api.util.KeyTypeSelection;
import appeng.core.AppEng;
import appeng.core.definitions.AEItems;
import appeng.items.parts.PartModels;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.prioritylist.IPartitionList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.api.AAESettings;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.helpers.FilteredImportStackTransferContext;
import net.pedroksl.advanced_ae.common.parts.StockExportBusPart;
import org.jetbrains.annotations.Nullable;

public class AdvancedIOBusPart
extends StockExportBusPart {
    public static final ResourceLocation MODEL_BASE = AdvancedAE.makeId("part/advanced_io_bus_part");
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_off")});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_on")});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODEL_BASE, AppEng.makeId((String)"part/export_bus_has_channel")});
    @Nullable
    private StackImportStrategy importStrategy;
    private final KeyTypeSelection keyTypeSelection = new KeyTypeSelection(() -> {
        this.getHost().markForSave();
        this.importStrategy = null;
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }, StackWorldBehaviors.hasImportStrategyTypeFilter());

    public AdvancedIOBusPart(IPartItem<?> partItem) {
        super(partItem);
    }

    @Override
    protected int getUpgradeSlots() {
        return 8;
    }

    protected void registerSettings(IConfigManagerBuilder builder) {
        super.registerSettings(builder);
        builder.registerSetting(AAESettings.REGULATE_STOCK, (Enum)YesNo.YES);
    }

    public StackImportStrategy getImportStrategy() {
        if (this.importStrategy == null) {
            BlockEntity self = this.getHost().getBlockEntity();
            BlockPos fromPos = self.getBlockPos().relative(this.getSide());
            Direction fromSide = this.getSide().getOpposite();
            this.importStrategy = StackWorldBehaviors.createImportFacade((ServerLevel)((ServerLevel)this.getLevel()), (BlockPos)fromPos, (Direction)fromSide, (Predicate)this.keyTypeSelection.enabledPredicate());
        }
        return this.importStrategy;
    }

    @Override
    protected boolean doBusWork(IGrid grid) {
        boolean regulate;
        boolean exportWork = super.doBusWork(grid);
        IStorageService storageService = grid.getStorageService();
        ICraftingService cg = grid.getCraftingService();
        StackImportStrategy strategy = this.getImportStrategy();
        boolean importWork = false;
        int operationsLeft = this.getOperationsPerTick();
        boolean bl = regulate = this.getConfigManager().getSetting(AAESettings.REGULATE_STOCK) == YesNo.YES;
        if (regulate) {
            SchedulingMode schedulingMode = (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
            for (int x = 0; x < this.availableSlots() && operationsLeft > 0; ++x) {
                int slotToExport = this.getStartingSlot(schedulingMode, x);
                GenericStack stack = this.getConfig().getStack(slotToExport);
                if (stack == null || stack.what() == null) continue;
                AEKey what = stack.what();
                int amount = (int)stack.amount();
                int stock = (int)this.getCurrentStock(what);
                if (stock <= amount) continue;
                int transferFactor = what.getAmountPerOperation();
                int maxAmount = operationsLeft * transferFactor;
                maxAmount = Math.min(maxAmount, stock - amount);
                int op = maxAmount * transferFactor;
                FilteredImportStackTransferContext context = new FilteredImportStackTransferContext(storageService, (IEnergySource)grid.getEnergyService(), this.source, op, this.makeFilter(what));
                strategy.transfer((StackTransferContext)context);
                operationsLeft -= op - context.getOperationsRemaining();
                importWork |= context.hasDoneWork();
            }
        }
        if (operationsLeft > 0) {
            FilteredImportStackTransferContext context = new FilteredImportStackTransferContext(grid.getStorageService(), (IEnergySource)grid.getEnergyService(), this.source, this.getOperationsPerTick(), this.getFilter());
            context.setInverted(this.isUpgradedWith((ItemLike)AEItems.INVERTER_CARD));
            strategy.transfer((StackTransferContext)context);
            importWork |= context.hasDoneWork();
        }
        return exportWork || importWork;
    }

    private IPartitionList makeFilter(AEKey what) {
        IPartitionList.Builder builder = IPartitionList.builder();
        builder.add(what);
        if (this.isUpgradedWith((ItemLike)AEItems.FUZZY_CARD)) {
            builder.fuzzyMode((FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE));
        }
        return builder.build();
    }

    @Override
    protected MenuType<?> getMenuType() {
        return AAEMenus.ADVANCED_IO_BUS.get();
    }

    protected int getOperationsPerTick() {
        return super.getOperationsPerTick() * 8;
    }

    @Override
    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        MenuOpener.open(AAEMenus.ADVANCED_IO_BUS.get(), (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

