/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.inventory;

import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.storage.ISubMenuHost;
import appeng.hooks.ticking.TickHandler;
import appeng.menu.ISubMenu;
import appeng.menu.guisync.GuiSync;
import appeng.menu.locator.ItemMenuHostLocator;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeysRegistry;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.QuantumUpgradeBaseItem;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.ae2addonlib.registry.helpers.LibComponents;

public class QuantumArmorMenuHost<T extends QuantumArmorBase>
extends ItemMenuHost<T>
implements InternalInventoryHost,
ISubMenuHost {
    private static final int MAX_PROCESSING_TIME = 10;
    private final AppEngInternalInventory input = new AppEngInternalInventory((InternalInventoryHost)this, 1, 1);
    private ProgressChangedHandler progressChangedHandler;
    private InventoryChangedHandler invChangeHandler;
    private ClientUpdater clientUpdater;
    private final BiConsumer<Player, ISubMenu> returnToMainMenu;
    private long consumeCardStartTick = -1L;
    @GuiSync(value=10)
    private int selectedItemSlot = -1;

    public QuantumArmorMenuHost(T item, Player player, ItemMenuHostLocator locator, BiConsumer<Player, ISubMenu> returnToMainMenu) {
        super(item, player, locator);
        this.returnToMainMenu = returnToMainMenu;
        CompoundTag itemTag = (CompoundTag)this.getItemStack().get(LibComponents.NBT_TAG);
        RegistryAccess registry = player.registryAccess();
        if (itemTag != null) {
            this.input.readFromNBT(itemTag, "input", (HolderLookup.Provider)registry);
        }
    }

    public void tick() {
        int progressTime;
        ItemStack inputCard = this.input.getStackInSlot(0);
        if (inputCard.isEmpty() || this.selectedItemSlot == -1) {
            this.resetProgress();
            return;
        }
        ItemStack stack = super.getPlayer().getInventory().getItem(this.selectedItemSlot);
        Item item = stack.getItem();
        if (!(item instanceof QuantumArmorBase)) {
            this.resetProgress();
            return;
        }
        QuantumArmorBase item2 = (QuantumArmorBase)item;
        QuantumUpgradeBaseItem card = (QuantumUpgradeBaseItem)inputCard.getItem();
        if (!item2.isUpgradeAllowed(card.getType()) || item2.hasUpgrade(stack, card.getType())) {
            this.resetProgress();
            return;
        }
        long currentTick = TickHandler.instance().getCurrentTick();
        if (this.consumeCardStartTick == -1L) {
            this.consumeCardStartTick = currentTick;
        }
        if ((progressTime = (int)(currentTick - this.consumeCardStartTick)) >= 10) {
            progressTime = -1;
            this.updateProgress(progressTime);
            UpgradeType type = card.getType();
            if (item2.applyUpgrade(stack, type)) {
                this.input.setItemDirect(0, ItemStack.EMPTY);
                if (this.clientUpdater != null) {
                    this.clientUpdater.updateClient();
                }
            }
        } else {
            this.updateProgress(progressTime);
        }
    }

    public void setSelectedItemSlot(int slot) {
        this.resetProgress();
        this.selectedItemSlot = slot;
    }

    public int getSelectedSlotIndex() {
        return this.selectedItemSlot;
    }

    private void resetProgress() {
        if (this.consumeCardStartTick != -1L) {
            this.consumeCardStartTick = -1L;
            this.updateProgress(-1);
        }
    }

    public int getMaxProcessingTime() {
        return 10;
    }

    private void updateProgress(int value) {
        if (this.progressChangedHandler != null) {
            this.progressChangedHandler.handleProgress(value);
        }
    }

    public void saveChangedInventory(AppEngInternalInventory appEngInternalInventory) {
        CompoundTag itemTag = new CompoundTag();
        RegistryAccess registry = this.getPlayer().registryAccess();
        this.input.writeToNBT(itemTag, "input", (HolderLookup.Provider)registry);
        if (!itemTag.isEmpty()) {
            this.getItemStack().set(LibComponents.NBT_TAG, (Object)itemTag);
        } else {
            this.getItemStack().remove(LibComponents.NBT_TAG);
        }
    }

    public void onChangeInventory(AppEngInternalInventory inv, int slot) {
        CompoundTag itemTag = (CompoundTag)this.getItemStack().getOrDefault(LibComponents.NBT_TAG, (Object)new CompoundTag());
        RegistryAccess registry = this.getPlayer().registryAccess();
        if (this.input == inv) {
            this.input.writeToNBT(itemTag, "input", (HolderLookup.Provider)registry);
        }
        if (!itemTag.isEmpty()) {
            this.getItemStack().set(LibComponents.NBT_TAG, (Object)itemTag);
        } else {
            this.getItemStack().remove(LibComponents.NBT_TAG);
        }
        if (this.invChangeHandler != null) {
            this.invChangeHandler.handleChange(inv, slot);
        }
    }

    public void returnToMainMenu(Player player, ISubMenu iSubMenu) {
        this.returnToMainMenu.accept(player, iSubMenu);
    }

    public ItemStack getMainMenuIcon() {
        return this.getItemStack();
    }

    public void setProgressChangedHandler(ProgressChangedHandler handler) {
        this.progressChangedHandler = handler;
    }

    public void setUpgradeAppliedWatcher(ClientUpdater handler) {
        this.clientUpdater = handler;
    }

    public void setInventoryChangedHandler(InventoryChangedHandler handler) {
        this.invChangeHandler = handler;
    }

    public AppEngInternalInventory getInventory() {
        return this.input;
    }

    public String getCloseHotkey() {
        return AAEHotkeysRegistry.Keys.ARMOR_CONFIG.getId();
    }

    @FunctionalInterface
    public static interface ClientUpdater {
        public void updateClient();
    }

    @FunctionalInterface
    public static interface ProgressChangedHandler {
        public void handleProgress(int var1);
    }

    @FunctionalInterface
    public static interface InventoryChangedHandler {
        public void handleChange(AppEngInternalInventory var1, int var2);
    }
}

