/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.widgets;

import appeng.client.gui.Icon;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AECheckbox;
import appeng.client.gui.widgets.IconButton;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorConfigScreen;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIcon;
import net.pedroksl.advanced_ae.client.widgets.UpgradeState;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.network.packet.quantumarmor.QuantumArmorUpgradeTogglePacket;
import net.pedroksl.ae2addonlib.client.widgets.AddonIconButton;

@OnlyIn(value=Dist.CLIENT)
public class QuantumUpgradeWidget {
    private final QuantumArmorConfigScreen host;
    private final int index;
    private final int x;
    private int y;
    private final ScreenStyle style;
    private UpgradeState state;
    private final Map<String, AbstractWidget> children = new HashMap<String, AbstractWidget>();
    private ConfigButton configureButton;
    private AECheckbox enableButton;
    private UninstallButton uninstallButton;

    public QuantumUpgradeWidget(QuantumArmorConfigScreen host, int index, int x, int y, ScreenStyle style, UpgradeState state) {
        this.host = host;
        this.index = index;
        this.x = x;
        this.y = y;
        this.style = style;
        this.state = state;
    }

    public void add() {
        if (this.state.type().getSettingType() != UpgradeType.SettingType.NONE) {
            this.configureButton = new ConfigButton(this.x + 72, this.y - 2, this::configRequested);
            this.host.addChildWidget("upgrade_config" + this.index, (AbstractWidget)this.configureButton, this.children);
        }
        this.enableButton = new AECheckbox(this.x + 90, this.y + 1, 16, 16, this.style, (Component)Component.empty());
        this.enableButton.setSelected(this.state.enabled());
        this.enableButton.setChangeListener(this::toggleEnable);
        this.host.addChildWidget("upgrade_enable" + this.index, (AbstractWidget)this.enableButton, this.children);
        this.uninstallButton = new UninstallButton(this.x + 113, this.y - 2, this::uninstallRequested);
        this.host.addChildWidget("upgrade_uninstall" + this.index, (AbstractWidget)this.uninstallButton, this.children);
    }

    public void hide() {
        this.children.values().forEach(w -> {
            if (w.visible) {
                w.visible = false;
            }
        });
    }

    public void show() {
        this.children.values().forEach(w -> {
            if (!w.visible) {
                w.visible = true;
            }
        });
    }

    public Collection<AbstractWidget> children() {
        return this.children.values();
    }

    public String getName() {
        return this.state.type().name;
    }

    public UpgradeType getType() {
        return this.state.type();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y, int topPos) {
        this.y = y;
        this.children.values().forEach(w -> {
            if (w instanceof AECheckbox) {
                w.setY(topPos + y + 1);
            } else {
                w.setY(topPos + y - 2);
            }
        });
    }

    public void setState(UpgradeState state) {
        this.state = state;
        this.enableButton.setSelected(state.enabled());
    }

    private void configRequested(Button button) {
        this.host.openConfigDialog(this.state);
    }

    private void toggleEnable() {
        PacketDistributor.sendToServer((CustomPacketPayload)new QuantumArmorUpgradeTogglePacket(this.state.type(), this.enableButton.isSelected()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void uninstallRequested(Button button) {
        this.host.requestUninstall(this.state.type());
    }

    static class ConfigButton
    extends IconButton {
        public ConfigButton(int x, int y, Button.OnPress onPress) {
            super(onPress);
            this.setX(x);
            this.setY(y);
            this.setDisableBackground(true);
        }

        protected Icon getIcon() {
            return this.isHoveredOrFocused() ? Icon.COG : Icon.COG_DISABLED;
        }
    }

    static class UninstallButton
    extends AddonIconButton {
        public UninstallButton(int x, int y, Button.OnPress onPress) {
            super(onPress);
            this.setX(x);
            this.setY(y);
            this.setDisableBackground(true);
        }

        protected AAEIcon getIcon() {
            return this.isHoveredOrFocused() ? AAEIcon.CLEAR : AAEIcon.CLEAR_DISABLED;
        }
    }
}

