/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPosMutable;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDhTintGetter
implements BlockAndTintGetter {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    protected final BiomeWrapper biomeWrapper;
    protected final int smoothingRadiusInBlocks;
    protected final FullDataSourceV2 fullDataSource;
    protected final IClientLevelWrapper clientLevelWrapper;
    public static final ConcurrentMap<String, Holder<Biome>> BIOME_BY_RESOURCE_STRING = new ConcurrentHashMap<String, Holder<Biome>>();

    public AbstractDhTintGetter(BiomeWrapper biomeWrapper, FullDataSourceV2 fullDataSource, IClientLevelWrapper clientLevelWrapper) {
        this.biomeWrapper = biomeWrapper;
        this.fullDataSource = fullDataSource;
        this.clientLevelWrapper = clientLevelWrapper;
        this.smoothingRadiusInBlocks = Config.Client.Advanced.Graphics.Quality.lodBiomeBlending.get();
    }

    public int getBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        byte dataSourceDetailLevel = DhSectionPos.getDetailLevel(this.fullDataSource.getPos());
        dataSourceDetailLevel = (byte)(dataSourceDetailLevel - 6);
        int dataSourceLodWidthInBlocks = DhSectionPos.getDetailLevelWidthInBlocks(dataSourceDetailLevel);
        if (this.smoothingRadiusInBlocks == 0 || dataSourceLodWidthInBlocks > this.smoothingRadiusInBlocks) {
            return colorResolver.getColor(AbstractDhTintGetter.unwrapClientBiome(this.biomeWrapper.biome, this.clientLevelWrapper), (double)blockPos.getX(), (double)blockPos.getZ());
        }
        int dataPointCount = 0;
        int rollingRed = 0;
        int rollingGreen = 0;
        int rollingBlue = 0;
        int xMin = blockPos.getX() - this.smoothingRadiusInBlocks;
        int xMax = blockPos.getX() + this.smoothingRadiusInBlocks;
        int zMin = blockPos.getZ() - this.smoothingRadiusInBlocks;
        int zMax = blockPos.getZ() + this.smoothingRadiusInBlocks;
        DhBlockPosMutable mutableBlockPos = new DhBlockPosMutable(0, blockPos.getY(), 0);
        for (int x = xMin; x < xMax; ++x) {
            for (int z = zMin; z < zMax; ++z) {
                mutableBlockPos.setX(x);
                mutableBlockPos.setZ(z);
                long dataPoint = this.fullDataSource.getAtBlockPos(mutableBlockPos);
                if (dataPoint == 0L) continue;
                int id = FullDataPointUtil.getId(dataPoint);
                BiomeWrapper biomeWrapper = (BiomeWrapper)this.fullDataSource.mapping.getBiomeWrapper(id);
                int color = colorResolver.getColor(AbstractDhTintGetter.unwrapClientBiome(biomeWrapper.biome, this.clientLevelWrapper), (double)mutableBlockPos.getX(), (double)mutableBlockPos.getZ());
                rollingRed += ColorUtil.getRed(color);
                rollingGreen += ColorUtil.getGreen(color);
                rollingBlue += ColorUtil.getBlue(color);
                ++dataPointCount;
            }
        }
        if (dataPointCount == 0) {
            return colorResolver.getColor(AbstractDhTintGetter.unwrapClientBiome(this.biomeWrapper.biome, this.clientLevelWrapper), (double)blockPos.getX(), (double)blockPos.getZ());
        }
        int colorInt = ColorUtil.argbToInt(255, rollingRed / dataPointCount, rollingGreen / dataPointCount, rollingBlue / dataPointCount);
        return colorInt;
    }

    protected static Biome unwrapClientBiome(Holder<Biome> biome, IClientLevelWrapper clientLevelWrapper) {
        BiomeWrapper biomeWrapper = (BiomeWrapper)BiomeWrapper.getBiomeWrapper(biome, clientLevelWrapper);
        String biomeString = biomeWrapper.getSerialString();
        if (biomeString == null || biomeString.isEmpty() || biomeString.equals("EMPTY")) {
            biomeString = "minecraft:plains";
        }
        return AbstractDhTintGetter.unwrapBiome(AbstractDhTintGetter.getClientBiome(biomeString));
    }

    protected static Biome unwrapBiome(Holder<Biome> biome) {
        return (Biome)biome.value();
    }

    private static Holder<Biome> getClientBiome(String biomeResourceString) {
        return BIOME_BY_RESOURCE_STRING.compute(biomeResourceString, (resourceString, existingBiome) -> {
            BiomeWrapper.BiomeDeserializeResult result;
            if (existingBiome != null) {
                return existingBiome;
            }
            ClientLevel clientLevel = Minecraft.getInstance().level;
            if (clientLevel == null) {
                throw new IllegalStateException("Attempted to get client biome when no client level was loaded.");
            }
            try {
                result = BiomeWrapper.deserializeBiome(resourceString, clientLevel.registryAccess());
            }
            catch (Exception e) {
                LOGGER.warn("Unable to deserialize client biome [" + resourceString + "], using fallback...");
                try {
                    result = BiomeWrapper.deserializeBiome("minecraft:plains", clientLevel.registryAccess());
                }
                catch (IOException ex) {
                    LOGGER.error("Unable to deserialize fallback client biome [minecraft:plains], returning NULL.");
                    return null;
                }
            }
            if (result.success) {
                existingBiome = result.biome;
            }
            return existingBiome;
        });
    }
}

