/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mcjty.rftoolsbase.api.xnet.channels.IChannelType;
import mcjty.rftoolsbase.api.xnet.channels.IConnectorSettings;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import mcjty.xnet.XNet;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class ConnectorInfo {
    private final IChannelType type;
    private final SidedConsumer id;
    private final IConnectorSettings connectorSettings;
    private final boolean advanced;
    public static final Codec<IConnectorSettings> CONNECTOR_SETTINGS_CODEC = Codec.lazyInitialized(() -> Codec.STRING.dispatch("type", e -> e.getType().getID(), s -> XNet.xNetApi.findType((String)s).getConnectorCodec()));
    public static final Codec<ConnectorInfo> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CONNECTOR_SETTINGS_CODEC.fieldOf("settings").forGetter(ConnectorInfo::getConnectorSettings), (App)SidedConsumer.CODEC.fieldOf("id").forGetter(ConnectorInfo::getId), (App)Codec.BOOL.fieldOf("advanced").forGetter(ConnectorInfo::isAdvanced)).apply((Applicative)instance, ConnectorInfo::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ConnectorInfo> STREAM_CODEC = StreamCodec.of((buf, info) -> {
        buf.writeUtf(info.type.getID());
        StreamCodec streamCodec = info.type.getConnectorStreamCodec();
        streamCodec.encode(buf, (Object)info.connectorSettings);
        SidedConsumer.STREAM_CODEC.encode(buf, (Object)info.id);
        buf.writeBoolean(info.isAdvanced());
    }, buf -> {
        String id = buf.readUtf(Short.MAX_VALUE);
        IChannelType type = XNet.xNetApi.findType(id);
        IConnectorSettings settings = (IConnectorSettings)type.getConnectorStreamCodec().decode(buf);
        SidedConsumer sidedConsumer = (SidedConsumer)SidedConsumer.STREAM_CODEC.decode(buf);
        boolean advanced = buf.readBoolean();
        return new ConnectorInfo(settings, sidedConsumer, advanced);
    });

    public ConnectorInfo(IConnectorSettings connectorSettings, SidedConsumer id, boolean advanced) {
        this.connectorSettings = connectorSettings;
        this.id = id;
        this.advanced = advanced;
        this.type = connectorSettings.getType();
    }

    public ConnectorInfo(IChannelType type, SidedConsumer id, boolean advanced) {
        this.type = type;
        this.id = id;
        this.advanced = advanced;
        this.connectorSettings = type.createConnector(id.side().getOpposite());
    }

    public IChannelType getType() {
        return this.type;
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public IConnectorSettings getConnectorSettings() {
        return this.connectorSettings;
    }

    public SidedConsumer getId() {
        return this.id;
    }
}

