/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.dysoncubeproject.client.render;

import com.buuz135.dysoncubeproject.Config;
import com.buuz135.dysoncubeproject.client.DCPRenderTypes;
import com.buuz135.dysoncubeproject.client.DCPShaders;
import com.buuz135.dysoncubeproject.world.ClientDysonSphere;
import com.buuz135.dysoncubeproject.world.DysonSphereStructure;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class SkyRender {
    public static void onRenderStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SKY) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.level.isRainingAt(mc.player.getOnPos())) {
            return;
        }
        String subscribedTo = ClientDysonSphere.DYSON_SPHERE_PROGRESS.getSubscribedPlayers().getOrDefault(mc.player.getStringUUID(), mc.player.getStringUUID());
        DysonSphereStructure sphere = ClientDysonSphere.DYSON_SPHERE_PROGRESS.getSpheres().getOrDefault(subscribedTo, null);
        if (sphere == null) {
            return;
        }
        float progress = (float)sphere.getProgress();
        if (Config.SHOW_AT_MAX_PROGRESS) {
            progress = 1.0f;
        }
        PoseStack pose = event.getPoseStack();
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        float skyAngle = mc.level.getTimeOfDay(event.getPartialTick().getGameTimeDeltaTicks()) * 360.0f;
        if (DCPShaders.DYSON_SUN != null) {
            block14: {
                ShaderInstance shader = DCPShaders.HOLO_HEX;
                try {
                    Uniform uCam;
                    Uniform uSize;
                    Uniform uValid;
                    Uniform uTime = shader.getUniform("uTime");
                    if (uTime != null) {
                        uTime.set((float)(Minecraft.getInstance().level.getGameTime() % 100000L) / 20.0f);
                    }
                    if ((uValid = shader.getUniform("uValid")) != null) {
                        uValid.set(1.0f);
                    }
                    if ((uSize = shader.getUniform("uSize")) != null) {
                        uSize.set(25.0f);
                    }
                    if ((uCam = shader.getUniform("uCamPos")) == null) break block14;
                    Vec3 c = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                    try {
                        uCam.set(0.0f, 0.0f, 0.0f);
                    }
                    catch (Throwable t) {
                        try {
                            uCam.set((float)c.x, (float)c.y, (float)c.z, 1.0f);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                catch (Throwable uTime) {
                    // empty catch block
                }
            }
            pose.pushPose();
            pose.mulPose(Axis.YP.rotationDegrees(-90.0f));
            pose.mulPose(Axis.XP.rotationDegrees(90.0f));
            pose.mulPose(Axis.XP.rotationDegrees(skyAngle));
            pose.translate(-30.0f, 0.0f, -310.0f);
            float s = 30.0f;
            float r = 0.5f;
            float g = 0.9f;
            float b = 0.9f;
            float a = 0.7f;
            float rainLevel = 1.0f - mc.level.getRainLevel(event.getPartialTick().getGameTimeDeltaTicks());
            VertexConsumer vc = buffer.getBuffer(DCPRenderTypes.holoHex());
            SkyRender.emit(vc, pose, 0.0f, s, 0.0f, r, g, b, a *= rainLevel);
            SkyRender.emit(vc, pose, s * 2.0f * progress, s, 0.0f, r, g, b, a);
            SkyRender.emit(vc, pose, s * 2.0f * progress, -s, 0.0f, r, g, b, a);
            SkyRender.emit(vc, pose, 0.0f, -s, 0.0f, r, g, b, a);
            pose.popPose();
            buffer.endBatch(DCPRenderTypes.dysonSun());
        }
    }

    private static void emit(VertexConsumer vc, PoseStack pose, float x, float y, float z, float r, float g, float b, float a) {
        vc.addVertex(pose.last().pose(), x, y, z).setColor(r, g, b, a);
    }
}

