/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.dysoncubeproject.client;

import com.buuz135.dysoncubeproject.DCPAttachments;
import com.buuz135.dysoncubeproject.DCPContent;
import com.buuz135.dysoncubeproject.client.DCPExtraModels;
import com.buuz135.dysoncubeproject.client.DCPShaders;
import com.buuz135.dysoncubeproject.client.render.HologramRender;
import com.buuz135.dysoncubeproject.client.render.SkyRender;
import com.buuz135.dysoncubeproject.client.tile.EMRailEjectorRender;
import com.buuz135.dysoncubeproject.client.tile.RayReceiverRender;
import com.hrznstudio.titanium.event.handler.EventManager;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.math.Transformation;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.SimpleModelState;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

public class ClientSetup {
    public static void init() {
        EventManager.forge(RenderHighlightEvent.Block.class).process(HologramRender::blockOverlayEvent).subscribe();
        EventManager.forge(RenderLevelStageEvent.class).process(SkyRender::onRenderStage).subscribe();
        EventManager.mod(RegisterShadersEvent.class).process(ClientSetup::registerShaders).subscribe();
        EventManager.mod(ModelEvent.BakingCompleted.class).process(event -> {
            DCPExtraModels.EM_RAILEJECTOR_BASE = ClientSetup.bakeModel(ResourceLocation.fromNamespaceAndPath((String)"dysoncubeproject", (String)"block/em_railejector_base"), event.getModelBakery());
            DCPExtraModels.EM_RAILEJECTOR_GUN = ClientSetup.bakeModel(ResourceLocation.fromNamespaceAndPath((String)"dysoncubeproject", (String)"block/em_railejector_gun"), event.getModelBakery());
            DCPExtraModels.EM_RAILEJECTOR_PROJECTILE = ClientSetup.bakeModel(ResourceLocation.fromNamespaceAndPath((String)"dysoncubeproject", (String)"block/em_railejector_projectile"), event.getModelBakery());
            DCPExtraModels.RAY_RECEIVER_BASE = ClientSetup.bakeModel(ResourceLocation.fromNamespaceAndPath((String)"dysoncubeproject", (String)"block/ray_receiver_base"), event.getModelBakery());
            DCPExtraModels.RAY_RECEIVER_PLATE = ClientSetup.bakeModel(ResourceLocation.fromNamespaceAndPath((String)"dysoncubeproject", (String)"block/ray_receiver_plate"), event.getModelBakery());
            DCPExtraModels.RAY_RECEIVER_LENS = ClientSetup.bakeModel(ResourceLocation.fromNamespaceAndPath((String)"dysoncubeproject", (String)"block/ray_receiver_lens"), event.getModelBakery());
            DCPExtraModels.RAY_RECEIVER_LENS_STANDS = ClientSetup.bakeModel(ResourceLocation.fromNamespaceAndPath((String)"dysoncubeproject", (String)"block/ray_receiver_lens_stands"), event.getModelBakery());
        }).subscribe();
        EventManager.mod(EntityRenderersEvent.RegisterRenderers.class).process(event -> {
            event.registerBlockEntityRenderer((BlockEntityType)DCPContent.Blocks.EM_RAILEJECTOR_CONTROLLER.type().get(), context -> new EMRailEjectorRender());
            event.registerBlockEntityRenderer((BlockEntityType)DCPContent.Blocks.RAY_RECEIVER_CONTROLLER.type().get(), context -> new RayReceiverRender());
        }).subscribe();
        EventManager.forge(ItemTooltipEvent.class).process(itemTooltipEvent -> {
            ItemStack stack = itemTooltipEvent.getItemStack();
            if ((Integer)stack.getOrDefault(DCPAttachments.SOLAR_SAIL, (Object)0) > 0) {
                itemTooltipEvent.getToolTip().add(Component.translatable((String)"tooltip.dysoncubeproject.contains_solar_sails", (Object[])new Object[]{stack.getOrDefault(DCPAttachments.SOLAR_SAIL, (Object)0)}).withColor(DCPContent.CYAN_COLOR));
            }
            if ((Integer)stack.getOrDefault(DCPAttachments.BEAM, (Object)0) > 0) {
                itemTooltipEvent.getToolTip().add(Component.translatable((String)"tooltip.dysoncubeproject.contains_beams", (Object[])new Object[]{stack.getOrDefault(DCPAttachments.BEAM, (Object)0)}).withColor(DCPContent.CYAN_COLOR));
            }
        }).subscribe();
    }

    public static void registerShaders(RegisterShadersEvent event) {
        ShaderInstance shader;
        try {
            shader = new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"dysoncubeproject", (String)"hologram"), DefaultVertexFormat.POSITION_COLOR);
            event.registerShader(shader, s -> {
                DCPShaders.HOLOGRAM = s;
            });
        }
        catch (Exception e) {
            DCPShaders.HOLOGRAM = null;
        }
        try {
            shader = new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"dysoncubeproject", (String)"dyson_sun"), DefaultVertexFormat.POSITION_COLOR);
            event.registerShader(shader, s -> {
                DCPShaders.DYSON_SUN = s;
            });
        }
        catch (Exception e) {
            DCPShaders.DYSON_SUN = null;
        }
        try {
            shader = new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"dysoncubeproject", (String)"holo_hex"), DefaultVertexFormat.POSITION_COLOR);
            event.registerShader(shader, s -> {
                DCPShaders.HOLO_HEX = s;
            });
        }
        catch (Exception e) {
            DCPShaders.HOLO_HEX = null;
        }
        try {
            shader = new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"dysoncubeproject", (String)"rail_electric"), DefaultVertexFormat.POSITION_COLOR);
            event.registerShader(shader, s -> {
                DCPShaders.RAIL_ELECTRIC = s;
            });
        }
        catch (Exception e) {
            DCPShaders.RAIL_ELECTRIC = null;
        }
        try {
            shader = new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)"dysoncubeproject", (String)"rail_beam"), DefaultVertexFormat.POSITION_COLOR);
            event.registerShader(shader, s -> {
                DCPShaders.RAIL_BEAM = s;
            });
        }
        catch (Exception e) {
            DCPShaders.RAIL_BEAM = null;
        }
    }

    private static BakedModel bakeModel(ResourceLocation model, ModelBakery modelBakery) {
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation(model, "standalone");
        UnbakedModel unbakedModel = modelBakery.getModel(model);
        ModelBakery.ModelBakerImpl baker = new ModelBakery.ModelBakerImpl(modelBakery, (modelLoc, material) -> material.sprite(), modelResourceLocation);
        return unbakedModel.bake((ModelBaker)baker, Material::sprite, (ModelState)new SimpleModelState(Transformation.identity()));
    }
}

