/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.dysoncubeproject.block.tile;

import com.buuz135.dysoncubeproject.DCPAttachments;
import com.buuz135.dysoncubeproject.DCPContent;
import com.buuz135.dysoncubeproject.client.gui.DysonProgressGuiAddon;
import com.buuz135.dysoncubeproject.client.gui.SubscribeDysonGuiAddon;
import com.buuz135.dysoncubeproject.world.DysonSphereProgressSavedData;
import com.buuz135.dysoncubeproject.world.DysonSphereStructure;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.IScreenAddonProvider;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.block.tile.ITickableBlockEntity;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IHasAssetProvider;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.container.BasicAddonContainer;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.network.IButtonHandler;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class EMRailEjectorBlockEntity
extends BasicTile<EMRailEjectorBlockEntity>
implements IScreenAddonProvider,
ITickableBlockEntity<EMRailEjectorBlockEntity>,
MenuProvider,
IButtonHandler,
IContainerAddonProvider,
IHasAssetProvider,
IComponentHarness {
    @Save
    private float currentYaw = 180.0f;
    @Save
    private float currentPitch = 90.0f;
    @Save
    private float targetYaw = 180.0f;
    @Save
    private float targetPitch = 90.0f;
    @Save
    private long lastExecution = 0L;
    @Save
    private ProgressBarComponent<EMRailEjectorBlockEntity> progressBarComponent = new ProgressBarComponent(32, 42, 120).setCanIncrease(iComponentHarness -> this.canIncrease()).setOnTickWork(() -> this.syncObject(this.progressBarComponent)).setOnFinishWork(this::onFinishWork).setIncreaseType(true).setComponentHarness((IComponentHarness)this).setBarDirection(ProgressBarComponent.BarDirection.ARROW_RIGHT).setColor(DyeColor.CYAN);
    @Save
    private InventoryComponent<EMRailEjectorBlockEntity> input = new InventoryComponent("input", 10, 42, 1).setInputFilter((itemStack, integer) -> (Integer)itemStack.getOrDefault(DCPAttachments.SOLAR_SAIL, (Object)0) > 0 || (Integer)itemStack.getOrDefault(DCPAttachments.BEAM, (Object)0) > 0).setSlotToColorRender(0, DyeColor.CYAN);
    @Save
    private String dysonSphereId = "";
    private int cooldown = 0;

    public EMRailEjectorBlockEntity(BasicTileBlock<EMRailEjectorBlockEntity> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
    }

    private boolean canIncrease() {
        if (this.cooldown > 0) {
            return false;
        }
        if (this.input.getStackInSlot(0).isEmpty()) {
            return false;
        }
        if (this.getLevel().isRaining() || this.getLevel().isNight() || !this.getLevel().canSeeSky(this.getBlockPos().above())) {
            return false;
        }
        float time = this.level.getTimeOfDay(1.0f) * 360.0f;
        if (time <= 10.0f || time >= 350.0f) {
            return false;
        }
        DysonSphereStructure dyson = DysonSphereProgressSavedData.get(this.level).getSpheres().computeIfAbsent(this.dysonSphereId, s -> new DysonSphereStructure());
        if (dyson.getProgress() >= 1.0) {
            return false;
        }
        Integer solarPanels = (Integer)this.input.getStackInSlot(0).getOrDefault(DCPAttachments.SOLAR_SAIL, (Object)0);
        Integer beams = (Integer)this.input.getStackInSlot(0).getOrDefault(DCPAttachments.BEAM, (Object)0);
        if (solarPanels > 0 && dyson.getSolarPanels() + solarPanels >= dyson.getMaxSolarPanels()) {
            return false;
        }
        return beams <= 0 || dyson.getBeams() < dyson.getMaxBeams();
    }

    private void onFinishWork() {
        DysonSphereProgressSavedData data = DysonSphereProgressSavedData.get(this.level);
        DysonSphereStructure dyson = data.getSpheres().computeIfAbsent(this.dysonSphereId, s -> new DysonSphereStructure());
        Integer solarPanels = (Integer)this.input.getStackInSlot(0).getOrDefault(DCPAttachments.SOLAR_SAIL, (Object)0);
        Integer beams = (Integer)this.input.getStackInSlot(0).getOrDefault(DCPAttachments.BEAM, (Object)0);
        this.input.getStackInSlot(0).shrink(1);
        this.lastExecution = this.getLevel().getGameTime();
        this.cooldown = 30;
        dyson.increaseBeams(beams);
        dyson.increaseSolarPanels(solarPanels);
        data.setDirty();
        this.syncObject(this.lastExecution);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, EMRailEjectorBlockEntity blockEntity) {
        if (this.progressBarComponent.getCanIncrease().test((EMRailEjectorBlockEntity)this.progressBarComponent.getComponentHarness())) {
            if (this.progressBarComponent.getIncreaseType() && this.progressBarComponent.getProgress() == 0) {
                this.progressBarComponent.onStart();
            }
            if (!this.progressBarComponent.getIncreaseType() && this.progressBarComponent.getProgress() == this.progressBarComponent.getMaxProgress()) {
                this.progressBarComponent.onStart();
            }
            this.progressBarComponent.tickBar();
        } else if (this.progressBarComponent.getCanReset().test((EMRailEjectorBlockEntity)this.progressBarComponent.getComponentHarness())) {
            this.progressBarComponent.setProgress(this.progressBarComponent.getIncreaseType() ? 0 : this.progressBarComponent.getMaxProgress());
        }
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        this.targetPitch = level.getTimeOfDay(1.0f) * 360.0f;
        if (this.targetPitch <= 10.0f) {
            this.targetPitch = 10.0f;
        }
        if (this.targetPitch >= 350.0f) {
            this.targetPitch = 10.0f;
        }
        this.targetYaw = this.targetPitch <= 90.0f ? 0.0f : 180.0f;
        if (this.targetPitch >= 90.0f && this.targetPitch <= 270.0f) {
            this.targetPitch = 90.0f;
        }
        if (this.targetPitch >= 270.0f) {
            this.targetPitch = 360.0f - this.targetPitch;
        }
        if (level.isRaining()) {
            this.targetPitch = 90.0f;
        }
        if (this.currentPitch <= this.targetPitch) {
            this.currentPitch = Math.min(this.currentPitch + 1.0f, this.targetPitch);
        } else if (this.currentPitch > this.targetPitch) {
            this.currentPitch = Math.max(this.currentPitch - 1.0f, this.targetPitch);
        }
        if (this.currentYaw <= this.targetYaw) {
            this.currentYaw = Math.min(this.currentYaw + 1.0f, this.targetYaw);
        } else if (this.currentYaw > this.targetYaw) {
            this.currentYaw = Math.max(this.currentYaw - 1.0f, this.targetYaw);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(Level level, BlockPos pos, BlockState state, EMRailEjectorBlockEntity blockEntity) {
        if (level instanceof ClientLevel) {
            ClientLevel clientLevel = (ClientLevel)level;
            if (this.progressBarComponent.getProgress() == 7) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)new SimpleSoundInstance((SoundEvent)DCPContent.Sounds.RAILGUN.get(), SoundSource.BLOCKS, 1.0f, 1.0f, level.getRandom(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ()));
            }
        }
    }

    public ItemInteractionResult onActivated(Player player, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ) {
        this.openGui(player);
        return ItemInteractionResult.SUCCESS;
    }

    public void openGui(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.openMenu((MenuProvider)this, buffer -> LocatorFactory.writePacketBuffer((RegistryFriendlyByteBuf)buffer, (LocatorInstance)new TileEntityLocatorInstance(this.worldPosition)));
        }
    }

    public float getCurrentPitch() {
        return this.currentPitch;
    }

    public float getCurrentYaw() {
        return this.currentYaw;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        ArrayList<IFactory<? extends IScreenAddon>> list = new ArrayList<IFactory<? extends IScreenAddon>>();
        list.addAll(this.progressBarComponent.getScreenAddons());
        list.addAll(this.input.getScreenAddons());
        list.add(() -> new DysonProgressGuiAddon(this.dysonSphereId, 62, 24));
        list.add(() -> new SubscribeDysonGuiAddon(this.dysonSphereId, 9, 84));
        return list;
    }

    public IAssetProvider getAssetProvider() {
        return IAssetProvider.DEFAULT_PROVIDER;
    }

    @NotNull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        ArrayList<IFactory<? extends IContainerAddon>> list = new ArrayList<IFactory<? extends IContainerAddon>>();
        list.addAll(this.progressBarComponent.getContainerAddons());
        list.addAll(this.input.getContainerAddons());
        return list;
    }

    public void handleButtonMessage(int i, Player player, CompoundTag compoundTag) {
    }

    @Nullable
    public AbstractContainerMenu createMenu(int menu, Inventory inventoryPlayer, Player entityPlayer) {
        return new BasicAddonContainer((Object)this, (LocatorInstance)new TileEntityLocatorInstance(this.worldPosition), this.getWorldPosCallable(), inventoryPlayer, menu);
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)this.getBasicTileBlock().getDescriptionId()).setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GRAY));
    }

    public ContainerLevelAccess getWorldPosCallable() {
        return this.getLevel() != null ? ContainerLevelAccess.create((Level)this.getLevel(), (BlockPos)this.getBlockPos()) : ContainerLevelAccess.NULL;
    }

    public Level getComponentWorld() {
        return this.level;
    }

    public void markComponentForUpdate(boolean b) {
        this.markForUpdate();
    }

    public void markComponentDirty() {
        this.markForUpdate();
    }

    public ProgressBarComponent<EMRailEjectorBlockEntity> getProgressBarComponent() {
        return this.progressBarComponent;
    }

    public long getLastExecution() {
        return this.lastExecution;
    }

    public String getDysonSphereId() {
        return this.dysonSphereId;
    }

    public void setDysonSphereId(String dysonSphereId) {
        this.dysonSphereId = dysonSphereId;
    }

    public InventoryComponent<EMRailEjectorBlockEntity> getInput() {
        return this.input;
    }
}

