/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.world;

import codechicken.chunkloader.api.IChunkLoader;
import codechicken.chunkloader.world.ChunkLoaderHandler;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;

public class ChunkTicket {
    private final ServerLevel level;
    private final ChunkPos pos;
    private final Set<IChunkLoader> loaders = new HashSet<IChunkLoader>();

    public ChunkTicket(ServerLevel level, ChunkPos pos) {
        this.level = level;
        this.pos = pos;
    }

    public boolean addLoader(IChunkLoader loader) {
        boolean empty = this.loaders.isEmpty();
        if (this.loaders.add(loader)) {
            ChunkLoaderHandler.CONTROLLER.forceChunk(this.level, loader.pos(), this.pos.x, this.pos.z, true, true);
        }
        return empty;
    }

    public boolean remLoader(IChunkLoader loader) {
        if (this.loaders.remove(loader)) {
            ChunkLoaderHandler.CONTROLLER.forceChunk(this.level, loader.pos(), this.pos.x, this.pos.z, false, true);
        }
        return this.loaders.isEmpty();
    }

    public Set<IChunkLoader> getLoaders() {
        return Collections.unmodifiableSet(this.loaders);
    }
}

