/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.world;

import codechicken.chunkloader.api.IChunkLoader;
import codechicken.chunkloader.api.IChunkLoaderHandler;
import codechicken.chunkloader.handler.ChickenChunksConfig;
import codechicken.chunkloader.world.ChunkTicket;
import codechicken.chunkloader.world.Organiser;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.common.world.chunk.TicketHelper;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ChunkLoaderHandler
extends SavedData
implements IChunkLoaderHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final boolean DEBUG = Boolean.getBoolean("chickenchunks.loading.debug");
    public static final TicketController CONTROLLER = new TicketController(ResourceLocation.fromNamespaceAndPath((String)"chickenchunks", (String)"chunk_loaders"), (level, ticketHelper) -> {
        ticketHelper.getBlockTickets().keySet().forEach(arg_0 -> ((TicketHelper)ticketHelper).removeAllTickets(arg_0));
        ticketHelper.getEntityTickets().keySet().forEach(arg_0 -> ((TicketHelper)ticketHelper).removeAllTickets(arg_0));
    });
    @Nullable
    private static ChunkLoaderHandler instance;
    private final MinecraftServer server;
    private final Table<UUID, ResourceLocation, Organiser> playerOrganisers = HashBasedTable.create();
    private final Table<ResourceLocation, ChunkPos, ChunkTicket> activeTickets = HashBasedTable.create();
    private final List<Organiser> deviveList = new LinkedList<Organiser>();
    private final List<Organiser> reviveList = new LinkedList<Organiser>();
    private final Object2LongMap<UUID> loginTimes = new Object2LongOpenHashMap();

    public static void init(IEventBus modBus) {
        modBus.addListener(RegisterTicketControllersEvent.class, e -> e.register(CONTROLLER));
        NeoForge.EVENT_BUS.addListener(ChunkLoaderHandler::onPlayerLogin);
        NeoForge.EVENT_BUS.addListener(ChunkLoaderHandler::onPlayerLoggedOut);
        NeoForge.EVENT_BUS.addListener(ChunkLoaderHandler::onWorldLoad);
        NeoForge.EVENT_BUS.addListener(ChunkLoaderHandler::onWorldUnload);
        NeoForge.EVENT_BUS.addListener(ChunkLoaderHandler::onWorldTick);
    }

    @Nullable
    public static IChunkLoaderHandler instance() {
        return instance;
    }

    private static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player.level() instanceof ServerLevel) {
            ChunkLoaderHandler.getInstance().login(event);
        }
    }

    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player.level() instanceof ServerLevel) {
            ChunkLoaderHandler.getInstance().logout(event);
        }
    }

    private static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (!level.dimension().equals(Level.OVERWORLD)) {
            return;
        }
        if (instance != null) {
            throw new RuntimeException("Tried to re-init the overworld?");
        }
        instance = (ChunkLoaderHandler)level.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new ChunkLoaderHandler(level.getServer()), (t, r) -> new ChunkLoaderHandler(level.getServer(), (CompoundTag)t)), "chickenchunks");
        ChunkLoaderHandler.getInstance().onOverWorldLoad();
    }

    private static void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        if (!level.dimension().equals(Level.OVERWORLD)) {
            return;
        }
        instance = null;
    }

    private static void onWorldTick(LevelTickEvent.Post event) {
        ServerLevel level;
        Level level2 = event.getLevel();
        if (level2 instanceof ServerLevel && (level = (ServerLevel)level2).dimension() == Level.OVERWORLD && instance != null) {
            instance.tick(event);
        }
    }

    protected ChunkLoaderHandler(MinecraftServer server, CompoundTag tag) {
        this(server);
        this.load(tag);
    }

    protected ChunkLoaderHandler(MinecraftServer server) {
        this.server = server;
    }

    @Override
    public void addChunkLoader(IChunkLoader loader) {
        Objects.requireNonNull(loader);
        if (loader.getOwner() == null) {
            LOGGER.error("ChunkLoader at {} has null owner. Not processing.", (Object)loader.pos());
            return;
        }
        Organiser organiser = this.getOrganiser(loader);
        if (this.canLoadChunks(loader, loader.getChunks())) {
            organiser.addChunkLoader(loader);
        } else {
            loader.deactivate();
        }
    }

    @Override
    public void removeChunkLoader(IChunkLoader loader) {
        Objects.requireNonNull(loader);
        Organiser organiser = this.getOrganiser(loader);
        organiser.remChunkLoader(loader);
    }

    @Override
    public boolean canLoadChunks(IChunkLoader loader, Set<ChunkPos> newChunks) {
        Objects.requireNonNull(loader);
        UUID player = Objects.requireNonNull(loader.getOwner());
        ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(player);
        int totalLoaded = this.getLoadedChunkCount(player);
        Organiser organiser = this.getOrganiser(loader);
        Set<ChunkPos> currentLoaded = organiser.forcedChunksByLoader.get(loader);
        int netChange = newChunks.size();
        if (currentLoaded != null && !currentLoaded.isEmpty()) {
            netChange = newChunks.size() - Sets.intersection(newChunks, currentLoaded).size();
        }
        return ChickenChunksConfig.doesBypassRestrictions(this.server, player) || totalLoaded + netChange <= restrictions.getTotalAllowedChunks();
    }

    @Override
    public void updateLoader(IChunkLoader loader) {
        Objects.requireNonNull(loader);
        Organiser organiser = this.getOrganiser(loader);
        organiser.updateLoader(loader);
    }

    public void login(PlayerEvent.PlayerLoggedInEvent event) {
        this.loginTimes.put((Object)event.getEntity().getUUID(), System.currentTimeMillis());
        this.reviveList.addAll(this.playerOrganisers.row((Object)event.getEntity().getUUID()).values());
    }

    public void logout(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID player = event.getEntity().getUUID();
        ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(player);
        if (!restrictions.canLoadOffline()) {
            this.deviveList.addAll(this.playerOrganisers.row((Object)player).values());
        }
    }

    private void onOverWorldLoad() {
        for (Map.Entry playerEntry : this.playerOrganisers.rowMap().entrySet()) {
            long curr = System.currentTimeMillis();
            UUID player = (UUID)playerEntry.getKey();
            ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(player);
            int timeout = restrictions.getOfflineTimeout();
            long lastSeen = this.loginTimes.getOrDefault((Object)player, -1L);
            if (!restrictions.canLoadOffline() && lastSeen == -1L && (curr - lastSeen) / 60000L >= (long)timeout) continue;
            if (DEBUG) {
                LOGGER.info("Adding {} organizers to revive list for {}", (Object)((Map)playerEntry.getValue()).values().size(), (Object)player);
            }
            this.reviveList.addAll(((Map)playerEntry.getValue()).values());
        }
    }

    public void tick(LevelTickEvent.Post event) {
        if (event.getLevel().getGameTime() % 1200L == 0L) {
            long curr = System.currentTimeMillis();
            for (ServerPlayer serverPlayer : this.server.getPlayerList().getPlayers()) {
                this.loginTimes.put((Object)serverPlayer.getUUID(), curr);
            }
            for (Map.Entry entry : this.playerOrganisers.rowMap().entrySet()) {
                UUID player = (UUID)entry.getKey();
                ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(player);
                if (restrictions.canLoadOffline()) continue;
                int timeout = restrictions.getOfflineTimeout();
                long lastSeen = this.loginTimes.getOrDefault((Object)player, -1L);
                if (lastSeen == curr || timeout != 0 && lastSeen != -1L && (curr - lastSeen) / 60000L >= (long)timeout) continue;
                this.deviveList.addAll(((Map)entry.getValue()).values());
            }
        }
        this.playerOrganisers.values().forEach(Organiser::onTickEnd);
        for (Organiser organiser : this.reviveList) {
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)organiser.dim);
            ServerLevel serverLevel = this.server.getLevel(key);
            if (serverLevel == null) continue;
            organiser.revive(serverLevel);
        }
        this.reviveList.clear();
        for (Organiser organiser : this.deviveList) {
            organiser.devive();
        }
        this.deviveList.clear();
    }

    public void remChunk(IChunkLoader loader, ResourceLocation dim, ChunkPos pos) {
        ChunkTicket ticket = (ChunkTicket)this.activeTickets.get((Object)dim, (Object)pos);
        if (ticket != null) {
            if (ticket.remLoader(loader)) {
                this.activeTickets.remove((Object)dim, (Object)pos);
            }
            if (DEBUG) {
                LOGGER.info("Loader {} Un-Forcing chunk: {}", (Object)loader.pos(), (Object)pos);
            }
        }
    }

    public void addChunk(IChunkLoader loader, ResourceLocation dim, ChunkPos pos) {
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dim);
        ServerLevel world = Objects.requireNonNull(this.server.getLevel(key));
        ChunkTicket ticket = ChunkLoaderHandler.computeIfAbsent(this.activeTickets, dim, pos, () -> new ChunkTicket(world, pos));
        ticket.addLoader(loader);
        if (DEBUG) {
            LOGGER.info("Loader {} Forcing chunk: {}", (Object)loader.pos(), (Object)pos);
        }
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag playerList = new ListTag();
        for (Map.Entry playerEntry : this.playerOrganisers.rowMap().entrySet()) {
            CompoundTag playerTag = new CompoundTag();
            playerTag.putUUID("player", (UUID)playerEntry.getKey());
            ListTag dimensions = new ListTag();
            for (Map.Entry dimEntry : ((Map)playerEntry.getValue()).entrySet()) {
                if (((Organiser)dimEntry.getValue()).isEmpty()) continue;
                CompoundTag dimTag = new CompoundTag();
                dimTag.putString("dimension", ((ResourceLocation)dimEntry.getKey()).toString());
                dimTag.put("organiser", (Tag)((Organiser)dimEntry.getValue()).write(new CompoundTag()));
                dimensions.add((Object)dimTag);
            }
            if (dimensions.isEmpty()) continue;
            playerTag.put("dimensions", (Tag)dimensions);
            playerList.add((Object)playerTag);
        }
        tag.put("playerOrganisers", (Tag)playerList);
        ListTag loginList = new ListTag();
        for (Object2LongMap.Entry uuidEntry : this.loginTimes.object2LongEntrySet()) {
            CompoundTag playerTag = new CompoundTag();
            playerTag.putUUID("player", (UUID)uuidEntry.getKey());
            playerTag.putLong("time", uuidEntry.getLongValue());
            loginList.add((Object)playerTag);
        }
        tag.put("loginTimes", (Tag)loginList);
        return tag;
    }

    private void load(CompoundTag tag) {
        ListTag playerList = tag.getList("playerOrganisers", 10);
        for (int i = 0; i < playerList.size(); ++i) {
            CompoundTag playerTag = playerList.getCompound(i);
            UUID player = playerTag.getUUID("player");
            ListTag dimensions = playerTag.getList("dimensions", 10);
            for (int j = 0; j < dimensions.size(); ++j) {
                CompoundTag dimTag = dimensions.getCompound(j);
                ResourceLocation dim = ResourceLocation.parse((String)dimTag.getString("dimension"));
                Organiser organiser = new Organiser(this, dim, player).read(dimTag.getCompound("organiser"));
                this.playerOrganisers.put((Object)player, (Object)dim, (Object)organiser);
            }
        }
        ListTag loginList = tag.getList("times", 10);
        for (int i = 0; i < loginList.size(); ++i) {
            CompoundTag playerTag = loginList.getCompound(i);
            this.loginTimes.put((Object)playerTag.getUUID("player"), playerTag.getLong("time"));
        }
    }

    public boolean isDirty() {
        return true;
    }

    public int getLoadedChunkCount(UUID player) {
        return this.playerOrganisers.row((Object)player).values().stream().mapToInt(organiser -> organiser.forcedChunksByChunk.size()).sum();
    }

    public Organiser getOrganiser(IChunkLoader loader) {
        Objects.requireNonNull(loader);
        UUID player = Objects.requireNonNull(loader.getOwner());
        return this.getOrganiser((ResourceKey<Level>)loader.world().dimension(), player);
    }

    public Organiser getOrganiser(ResourceKey<Level> dim, UUID player) {
        return this.getOrganiser(dim.location(), player);
    }

    public Organiser getOrganiser(ResourceLocation dim, UUID player) {
        return ChunkLoaderHandler.computeIfAbsent(this.playerOrganisers, player, dim, () -> new Organiser(this, dim, player));
    }

    private static ChunkLoaderHandler getInstance() {
        return (ChunkLoaderHandler)IChunkLoaderHandler.instance();
    }

    private static <R, C, V> V computeIfAbsent(Table<R, C, V> table, R r, C c, Supplier<V> vFunc) {
        Object val = table.get(r, c);
        if (val == null) {
            val = vFunc.get();
            table.put(r, c, val);
        }
        return (V)val;
    }
}

