/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.tile;

import codechicken.chunkloader.api.IChunkLoader;
import codechicken.chunkloader.api.IChunkLoaderHandler;
import codechicken.chunkloader.network.ChunkLoaderSPH;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class TileChunkLoaderBase
extends BlockEntity
implements IChunkLoader {
    @Nullable
    public UUID owner;
    @Nullable
    public Component ownerName;
    protected boolean loaded = false;
    protected boolean unloaded = false;
    protected boolean powered = false;
    public boolean active = false;
    @Nullable
    public RenderInfo renderInfo;

    public TileChunkLoaderBase(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putBoolean("powered", this.powered);
        if (this.owner != null) {
            assert (this.ownerName != null);
            tag.putUUID("owner", this.owner);
            tag.putString("owner_name", Component.Serializer.toJson((Component)this.ownerName, (HolderLookup.Provider)registries));
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("owner")) {
            this.owner = tag.getUUID("owner");
            this.ownerName = Component.Serializer.fromJson((String)tag.getString("owner_name"), (HolderLookup.Provider)registries);
        }
        if (tag.contains("powered")) {
            this.powered = tag.getBoolean("powered");
        }
        this.loaded = true;
    }

    public void onLoad() {
        super.onLoad();
        assert (this.level != null);
        if (!this.level.isClientSide && this.loaded && !this.powered) {
            this.activate();
        }
        this.unloaded = false;
    }

    public void clearRemoved() {
        super.clearRemoved();
        assert (this.level != null);
        if (this.level.isClientSide) {
            this.renderInfo = new RenderInfo();
        }
        this.unloaded = false;
    }

    public boolean isPowered() {
        for (Direction face : Direction.BY_3D_DATA) {
            assert (this.level != null);
            boolean isPowered = TileChunkLoaderBase.isPoweringTo(this.level, this.getBlockPos().relative(face), face);
            if (!isPowered) continue;
            return true;
        }
        return false;
    }

    public static boolean isPoweringTo(Level world, BlockPos pos, Direction side) {
        BlockState state = world.getBlockState(pos);
        return state.getSignal((BlockGetter)world, pos, side) > 0;
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.unloaded = true;
    }

    public void setRemoved() {
        super.setRemoved();
        assert (this.level != null);
        if (!this.level.isClientSide && !this.unloaded) {
            this.deactivate();
        }
    }

    public ChunkPos getChunkPosition() {
        return new ChunkPos(this.getBlockPos().getX() >> 4, this.getBlockPos().getZ() >> 4);
    }

    public void onBlockPlacedBy(LivingEntity entityliving) {
        if (entityliving instanceof Player) {
            this.owner = entityliving.getUUID();
            this.ownerName = entityliving.getName();
        }
        this.activate();
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public Level world() {
        return Objects.requireNonNull(this.level);
    }

    @Override
    public BlockPos pos() {
        return this.getBlockPos();
    }

    @Override
    public void deactivate() {
        if (this.owner == null) {
            return;
        }
        this.loaded = true;
        this.active = false;
        IChunkLoaderHandler.instance().removeChunkLoader(this);
        ChunkLoaderSPH.sendStateUpdate(this);
    }

    @Override
    public void activate() {
        if (this.owner == null) {
            return;
        }
        this.loaded = true;
        this.active = true;
        IChunkLoaderHandler.instance().addChunkLoader(this);
        ChunkLoaderSPH.sendStateUpdate(this);
    }

    @Override
    public boolean isValid() {
        return !this.remove;
    }

    public void tickServer() {
        boolean nowPowered = this.isPowered();
        if (this.powered != nowPowered) {
            this.powered = nowPowered;
            if (this.powered) {
                this.deactivate();
            } else {
                this.activate();
            }
        }
    }

    public void tickClient() {
        assert (this.renderInfo != null);
        this.renderInfo.update(this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = this.saveWithoutMetadata(registries);
        tag.putBoolean("active", this.active);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        this.active = tag.getBoolean("active");
    }

    public void writeToPacket(MCDataOutput packet) {
        packet.writeBoolean(this.active);
        packet.writeBoolean(this.owner != null);
        if (this.owner != null) {
            packet.writeUUID(this.owner);
            assert (this.ownerName != null);
            packet.writeTextComponent(this.ownerName);
        }
    }

    public void readFromPacket(MCDataInput packet) {
        this.active = packet.readBoolean();
        if (packet.readBoolean()) {
            this.owner = packet.readUUID();
            this.ownerName = packet.readTextComponent();
        }
    }

    public static class RenderInfo {
        public int activationCounter;
        public boolean showLasers;

        public void update(TileChunkLoaderBase chunkLoader) {
            if (this.activationCounter < 20 && chunkLoader.active) {
                ++this.activationCounter;
            } else if (this.activationCounter > 0 && !chunkLoader.active) {
                --this.activationCounter;
            }
        }
    }
}

