/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.tile;

import codechicken.chunkloader.api.ChunkLoaderShape;
import codechicken.chunkloader.api.IChunkLoaderHandler;
import codechicken.chunkloader.handler.ChickenChunksConfig;
import codechicken.chunkloader.init.ChickenChunksModContent;
import codechicken.chunkloader.network.ChunkLoaderSPH;
import codechicken.chunkloader.tile.TileChunkLoaderBase;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TileChunkLoader
extends TileChunkLoaderBase {
    public int radius;
    public ChunkLoaderShape shape = ChunkLoaderShape.SQUARE;

    public TileChunkLoader(BlockPos pos, BlockState state) {
        super((BlockEntityType)ChickenChunksModContent.CHUNK_LOADER_TILE.get(), pos, state);
    }

    public boolean setShapeAndRadius(ChunkLoaderShape newShape, int newRadius) {
        return this.setShapeAndRadius(null, newShape, newRadius);
    }

    public boolean setShapeAndRadius(@Nullable ServerPlayer player, ChunkLoaderShape newShape, int newRadius) {
        if (this.owner == null || newRadius < 0 || newRadius > 255) {
            return false;
        }
        assert (this.level != null);
        if (this.level.isClientSide) {
            this.radius = newRadius;
            this.shape = newShape;
            return true;
        }
        Set<ChunkPos> chunks = TileChunkLoader.getContainedChunks(newShape, this.getBlockPos().getX(), this.getBlockPos().getZ(), newRadius);
        ChickenChunksConfig.Restrictions restrictions = ChickenChunksConfig.getRestrictions(this.owner);
        if (chunks.size() > restrictions.getChunksPerLoader()) {
            if (player != null) {
                int more = chunks.size() - restrictions.getChunksPerLoader();
                ChunkLoaderSPH.sendGuiWarning(player, (Component)Component.translatable((String)"chickenchunks.gui.morechunks", (Object[])new Object[]{more}));
            }
            return false;
        }
        if (this.powered) {
            this.radius = newRadius;
            this.shape = newShape;
            BlockState state = this.level.getBlockState(this.getBlockPos());
            this.level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
            ChunkLoaderSPH.sendStateUpdate(this);
            return true;
        }
        IChunkLoaderHandler handler = IChunkLoaderHandler.instance();
        if (handler.canLoadChunks(this, chunks)) {
            this.radius = newRadius;
            this.shape = newShape;
            handler.updateLoader(this);
            BlockState state = this.level.getBlockState(this.getBlockPos());
            this.level.sendBlockUpdated(this.getBlockPos(), state, state, 3);
            ChunkLoaderSPH.sendStateUpdate(this);
            return true;
        }
        return false;
    }

    @Override
    public void writeToPacket(MCDataOutput packet) {
        super.writeToPacket(packet);
        packet.writeEnum((Enum)this.shape);
        packet.writeByte(this.radius);
    }

    @Override
    public void readFromPacket(MCDataInput packet) {
        super.readFromPacket(packet);
        this.setShapeAndRadius((ChunkLoaderShape)packet.readEnum(ChunkLoaderShape.class), packet.readUByte());
    }

    @Override
    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putByte("radius", (byte)this.radius);
        tag.putByte("shape", (byte)this.shape.ordinal());
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.radius = tag.getByte("radius");
        this.shape = ChunkLoaderShape.values()[tag.getByte("shape")];
    }

    @Override
    public Set<ChunkPos> getChunks() {
        return TileChunkLoader.getContainedChunks(this.shape, this.getBlockPos().getX(), this.getBlockPos().getZ(), this.radius);
    }

    public static Set<ChunkPos> getContainedChunks(ChunkLoaderShape shape, int xCoord, int zCoord, int radius) {
        return shape.getLoadedChunks(xCoord >> 4, zCoord >> 4, radius - 1);
    }

    public int countLoadedChunks() {
        return this.getChunks().size();
    }

    @Override
    public void activate() {
        if (this.owner == null) {
            return;
        }
        if (this.radius == 0) {
            this.radius = 1;
            this.shape = ChunkLoaderShape.SQUARE;
            this.setShapeAndRadius(ChunkLoaderShape.SQUARE, 2);
        }
        super.activate();
    }
}

