/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.network;

import codechicken.chunkloader.api.ChunkLoaderShape;
import codechicken.chunkloader.network.ChickenChunksNetwork;
import codechicken.chunkloader.tile.TileChunkLoader;
import codechicken.chunkloader.tile.TileChunkLoaderBase;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ChunkLoaderSPH
implements ICustomPacketHandler.IServerPacketHandler {
    public void handlePacket(PacketCustom packet, ServerPlayer sender) {
        switch (packet.getType()) {
            case 1: {
                this.handleChunkLoaderChangePacket(sender.level(), sender, packet);
            }
        }
    }

    private void handleChunkLoaderChangePacket(Level world, ServerPlayer sender, PacketCustom packet) {
        BlockEntity blockEntity = world.getBlockEntity(packet.readPos());
        if (blockEntity instanceof TileChunkLoader) {
            TileChunkLoader tile = (TileChunkLoader)blockEntity;
            tile.setShapeAndRadius(sender, (ChunkLoaderShape)packet.readEnum(ChunkLoaderShape.class), packet.readShort());
        }
    }

    public static void sendStateUpdate(TileChunkLoaderBase tile) {
        if (tile.world().isClientSide) {
            return;
        }
        PacketCustom packet = new PacketCustom(ChickenChunksNetwork.NET_CHANNEL, 2, tile.getLevel().registryAccess());
        packet.writePos(tile.getBlockPos());
        tile.writeToPacket((MCDataOutput)packet);
        packet.sendToChunk((BlockEntity)tile);
    }

    public static void sendGuiWarning(ServerPlayer player, Component component) {
        PacketCustom packet = new PacketCustom(ChickenChunksNetwork.NET_CHANNEL, 3, player.registryAccess());
        packet.writeTextComponent(component);
        packet.sendToPlayer(player);
    }
}

