/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.network;

import codechicken.chunkloader.api.ChunkLoaderShape;
import codechicken.chunkloader.gui.GuiChunkLoader;
import codechicken.chunkloader.network.ChickenChunksNetwork;
import codechicken.chunkloader.tile.TileChunkLoader;
import codechicken.chunkloader.tile.TileChunkLoaderBase;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ChunkLoaderCPH
implements ICustomPacketHandler.IClientPacketHandler {
    public void handlePacket(PacketCustom packet, Minecraft mc) {
        switch (packet.getType()) {
            case 2: {
                BlockEntity blockEntity = Objects.requireNonNull(mc.level).getBlockEntity(packet.readPos());
                if (!(blockEntity instanceof TileChunkLoaderBase)) break;
                TileChunkLoaderBase chunkLoader = (TileChunkLoaderBase)blockEntity;
                chunkLoader.readFromPacket((MCDataInput)packet);
                break;
            }
            case 1: {
                BlockEntity blockEntity = Objects.requireNonNull(mc.level).getBlockEntity(packet.readPos());
                if (!(blockEntity instanceof TileChunkLoader)) break;
                TileChunkLoader tile = (TileChunkLoader)blockEntity;
                mc.setScreen((Screen)new GuiChunkLoader(tile));
                break;
            }
            case 3: {
                if (!(mc.screen instanceof GuiChunkLoader)) break;
                ((GuiChunkLoader)mc.screen).addWarning((Component)packet.readTextComponent());
            }
        }
    }

    public static void sendShapeChange(TileChunkLoader tile, ChunkLoaderShape shape, int radius) {
        if (radius < 0 || radius > 255) {
            return;
        }
        PacketCustom packet = new PacketCustom(ChickenChunksNetwork.NET_CHANNEL, 1, tile.getLevel().registryAccess());
        packet.writePos(tile.getBlockPos());
        packet.writeEnum((Enum)shape);
        packet.writeShort(radius);
        packet.sendToServer();
    }
}

