/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.init;

import codechicken.chunkloader.block.BlockChunkLoader;
import codechicken.chunkloader.block.BlockSpotLoader;
import codechicken.chunkloader.init.ChickenChunksModContent;
import codechicken.lib.datagen.ItemModelProvider;
import codechicken.lib.datagen.NoValidationBLockLootSubProvider;
import codechicken.lib.datagen.recipe.RecipeProvider;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

public class DataGenerators {
    private static final CrashLock LOCK = new CrashLock("Already initialized.");

    public static void init(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(DataGenerators::gatherDataGenerators);
    }

    private static void gatherDataGenerators(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper files = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new LootTables(output, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new BlockTags(output, lookupProvider, files));
        gen.addProvider(event.includeServer(), (DataProvider)new Recipes(lookupProvider, output));
        gen.addProvider(event.includeClient(), (DataProvider)new BlockStates(output, files));
        gen.addProvider(event.includeClient(), (DataProvider)new ItemModels(output, files));
    }

    private static class LootTables
    extends LootTableProvider {
        public LootTables(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLoot::new, LootContextParamSets.BLOCK)), lookupProvider);
        }
    }

    private static class BlockTags
    extends BlockTagsProvider {
        public BlockTags(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, lookupProvider, "chickenchunks", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider provider) {
            this.tag(net.minecraft.tags.BlockTags.MINEABLE_WITH_PICKAXE).add((Object)((Block)ChickenChunksModContent.CHUNK_LOADER_BLOCK.get())).add((Object)((Block)ChickenChunksModContent.SPOT_LOADER_BLOCK.get()));
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(CompletableFuture<HolderLookup.Provider> lookupProvider, PackOutput output) {
            super(lookupProvider, output, "chickenchunks");
        }

        protected void registerRecipes() {
            this.shapedRecipe((ItemLike)ChickenChunksModContent.CHUNK_LOADER_ITEM.get()).key('P', Tags.Items.ENDER_PEARLS).key('G', Tags.Items.INGOTS_GOLD).key('E', (ItemLike)Items.ENCHANTING_TABLE).patternLine(" P ").patternLine("GGG").patternLine("GEG");
            this.shapedRecipe((ItemLike)ChickenChunksModContent.SPOT_LOADER_ITEM.get()).key('P', Tags.Items.ENDER_PEARLS).key('C', ChickenChunksModContent.CHUNK_LOADER_ITEM).patternLine("PPP").patternLine("PCP").patternLine("PPP");
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
            super(output, "chickenchunks", exFileHelper);
        }

        protected void registerStatesAndModels() {
            this.simpleBlock((Block)ChickenChunksModContent.CHUNK_LOADER_BLOCK.get(), this.chunkLoader("chunk_loader", "full", BlockChunkLoader.SHAPE));
            this.simpleBlock((Block)ChickenChunksModContent.SPOT_LOADER_BLOCK.get(), this.chunkLoader("spot_loader", "spot", BlockSpotLoader.SHAPE));
        }

        private ModelFile chunkLoader(String name, String texturePrefix, VoxelShape shape) {
            AABB box = shape.bounds();
            return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).texture("particle", this.modLoc("block/" + texturePrefix + "/side"))).texture("top", this.modLoc("block/" + texturePrefix + "/top"))).texture("side", this.modLoc("block/" + texturePrefix + "/side"))).texture("bottom", this.modLoc("block/" + texturePrefix + "/bottom"))).element().from((float)box.minX * 16.0f, (float)box.minY * 16.0f, (float)box.minZ * 16.0f).to((float)box.maxX * 16.0f, (float)box.maxY * 16.0f, (float)box.maxZ * 16.0f).allFaces((dir, builder) -> {
                switch (dir) {
                    case NORTH: 
                    case EAST: 
                    case SOUTH: 
                    case WEST: {
                        builder.texture("#side");
                        break;
                    }
                    case UP: {
                        builder.texture("#top");
                        break;
                    }
                    case DOWN: {
                        builder.texture("#bottom");
                    }
                }
            }).end();
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "chickenchunks", existingFileHelper);
        }

        protected void registerModels() {
            ((ChunkLoaderItemModelLoaderBuilder)this.generated((ItemLike)ChickenChunksModContent.CHUNK_LOADER_ITEM.get()).noTexture().customLoader(ChunkLoaderItemModelLoaderBuilder::new)).childModel("chickenchunks:block/chunk_loader").spotLoader(false);
            ((ChunkLoaderItemModelLoaderBuilder)this.generated((ItemLike)ChickenChunksModContent.SPOT_LOADER_ITEM.get()).noTexture().customLoader(ChunkLoaderItemModelLoaderBuilder::new)).childModel("chickenchunks:block/spot_loader").spotLoader(true);
        }
    }

    private static class ChunkLoaderItemModelLoaderBuilder
    extends ItemModelProvider.CustomLoaderBuilder {
        @Nullable
        private String childModel;
        private boolean isSpotLoader;

        public ChunkLoaderItemModelLoaderBuilder(ItemModelProvider.SimpleItemModelBuilder parent) {
            super(ResourceLocation.fromNamespaceAndPath((String)"chickenchunks", (String)"chunk_loader"), parent);
        }

        public ChunkLoaderItemModelLoaderBuilder childModel(String childModel) {
            this.childModel = childModel;
            return this;
        }

        public ChunkLoaderItemModelLoaderBuilder spotLoader(boolean isSpotLoader) {
            this.isSpotLoader = isSpotLoader;
            return this;
        }

        protected JsonObject toJson(JsonObject json) {
            super.toJson(json);
            json.addProperty("childModel", Objects.requireNonNull(this.childModel));
            json.addProperty("isSpotLoader", Boolean.valueOf(this.isSpotLoader));
            return json;
        }
    }

    private static class BlockLoot
    extends NoValidationBLockLootSubProvider {
        public BlockLoot(HolderLookup.Provider registries) {
            super(Set.of((Item)ChickenChunksModContent.CHUNK_LOADER_ITEM.get(), (Item)ChickenChunksModContent.SPOT_LOADER_ITEM.get()), registries);
        }

        protected void generate() {
            this.dropSelf((Block)ChickenChunksModContent.CHUNK_LOADER_BLOCK.get());
            this.dropSelf((Block)ChickenChunksModContent.SPOT_LOADER_BLOCK.get());
        }
    }
}

